/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.metrics.TimerFieldBean;
import org.eclipse.microprofile.metrics.tck.util.MetricsUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TimerFieldBeanTest {
    private static final String[] METRIC_NAMES = new String[]{"timerWithoutAnnotation", "timerWithExplicitNonAbsoluteName", "timerWithNoName", "timerName"};
    private static final String[] ABSOLUTE_METRIC_NAMES = new String[]{"timerWithAbsoluteDefaultName", "timerAbsoluteName"};
    @Inject
    private MetricRegistry registry;
    @Inject
    private TimerFieldBean bean;

    private Set<String> metricNames() {
        Set<String> names = MetricsUtil.absoluteMetricNames(TimerFieldBean.class, METRIC_NAMES);
        names.addAll(Arrays.asList(ABSOLUTE_METRIC_NAMES));
        return names;
    }

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{TimerFieldBean.class, MetricsUtil.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void timerFieldsWithDefaultNamingConvention() {
        Assert.assertThat((String)"Timers are not registered correctly", (Object)this.registry.getMetricIDs(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(MetricsUtil.createMetricIDs(this.metricNames()))));
    }
}

