/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.tck.metrics.AbstractGenericBean;
import org.eclipse.microprofile.metrics.tck.metrics.ConcreteTimedBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ConcreteTimedBeanTest {
    private static final String TIMED_NAME = MetricRegistry.name(ConcreteTimedBean.class, (String[])new String[]{"timedMethod"});
    private static final String EXTENDED_TIMED_NAME = MetricRegistry.name(ConcreteTimedBean.class, (String[])new String[]{"normallyNotTimedMethod"});
    private static MetricID timerMID;
    private static MetricID extendedTimedMID;
    @Inject
    private ConcreteTimedBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{ConcreteTimedBean.class, AbstractGenericBean.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        timerMID = new MetricID(TIMED_NAME);
        extendedTimedMID = new MetricID(EXTENDED_TIMED_NAME);
    }

    @Test
    @InSequence(value=1)
    public void timedMethodNotCalledYet(MetricRegistry registry) {
        Timer timer = registry.getTimer(timerMID);
        Assert.assertThat((String)"Timer is not registered correctly", (Object)timer, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
    }

    @Test
    @InSequence(value=2)
    public void extendedTimedMethodNotCalledYet(MetricRegistry registry) {
        Timer timer = registry.getTimer(extendedTimedMID);
        Assert.assertThat((String)"Timer is not registered correctly on the methods on the abstract class", (Object)timer, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
    }

    @Test
    @InSequence(value=3)
    public void callTimedMethodOnce(MetricRegistry registry) {
        Timer timer = registry.getTimer(timerMID);
        Assert.assertThat((String)"Timer is not registered correctly", (Object)timer, (Matcher)Matchers.notNullValue());
        this.bean.timedMethod();
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
    }

    @Test
    @InSequence(value=4)
    public void callExtendedTimedMethodOnce(MetricRegistry registry) {
        Timer timer = registry.getTimer(extendedTimedMID);
        Assert.assertThat((String)"Timer is not registered correctly", (Object)timer, (Matcher)Matchers.notNullValue());
        this.bean.normallyNotTimedMethod();
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
    }
}

