/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import java.util.concurrent.Callable;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.tck.metrics.CountedMethodBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CountedMethodBeanTest {
    private static final String COUNTER_NAME = "countedMethod";
    private static MetricID counterMetricID;
    private static final AtomicLong COUNTER_COUNT;
    @Inject
    private MetricRegistry registry;
    @Inject
    private CountedMethodBean<Long> bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(CountedMethodBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        counterMetricID = new MetricID(COUNTER_NAME);
    }

    @Test
    @InSequence(value=1)
    public void countedMethodNotCalledYet() {
        Counter counter = this.registry.getCounter(counterMetricID);
        Assert.assertThat((String)"Counter is not registered correctly", (Object)counter, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Counter count is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)COUNTER_COUNT.get())));
    }

    @Test
    @InSequence(value=2)
    public void metricInjectionIntoTest(@Metric(name="countedMethod", absolute=true) Counter instance) {
        Counter counter = this.registry.getCounter(counterMetricID);
        Assert.assertThat((String)"Counter is not registered correctly", (Object)counter, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Counter and bean instance are not equal", (Object)instance, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)counter)));
    }

    @Test
    @InSequence(value=3)
    public void callCountedMethodOnce() throws InterruptedException, TimeoutException {
        Counter counter = this.registry.getCounter(counterMetricID);
        Assert.assertThat((String)"Counter is not registered correctly", (Object)counter, (Matcher)Matchers.notNullValue());
        final Exchanger<Long> exchanger = new Exchanger<Long>();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    exchanger.exchange(CountedMethodBeanTest.this.bean.countedMethod(new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            exchanger.exchange(0L);
                            return exchanger.exchange(0L);
                        }
                    }));
                }
                catch (InterruptedException cause) {
                    throw new RuntimeException(cause);
                }
            }
        });
        final AtomicInteger uncaught = new AtomicInteger();
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
                uncaught.incrementAndGet();
            }
        });
        thread.start();
        exchanger.exchange(0L, 5L, TimeUnit.SECONDS);
        Assert.assertThat((String)"Counter count is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)COUNTER_COUNT.incrementAndGet())));
        Long random = 1L + Math.round(Math.random() * 9.223372036854776E18);
        exchanger.exchange(random, 5L, TimeUnit.SECONDS);
        Assert.assertThat((String)"Counted method return value is incorrect", (Object)exchanger.exchange(0L), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)random)));
        Assert.assertThat((String)"Counter count is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)COUNTER_COUNT.get())));
        thread.join();
        Assert.assertThat((String)"Exception thrown in method call thread", (Object)uncaught.get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    @InSequence(value=4)
    public void removeCounterFromRegistry() {
        Counter counter = this.registry.getCounter(counterMetricID);
        Assert.assertThat((String)"Counter is not registered correctly", (Object)counter, (Matcher)Matchers.notNullValue());
        this.registry.remove(counterMetricID);
        try {
            this.bean.countedMethod(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return null;
                }
            });
        }
        catch (Exception cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class)));
            Assert.assertThat((String)"Counter count is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)COUNTER_COUNT.get())));
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }

    static {
        COUNTER_COUNT = new AtomicLong();
    }
}

