/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.tags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class GlobalTagsTest {
    @Inject
    private MetricRegistry registry;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @After
    public void cleanupApplicationMetrics() {
        this.registry.removeMatching(MetricFilter.ALL);
    }

    @Test
    public void fromEnvVariable() {
        this.registry.counter("mycounter", new Tag[]{new Tag("foo", "bar")});
        MetricID actualMetricId = this.registry.getCounters().keySet().stream().filter(id -> id.getName().equals("mycounter")).findAny().get();
        ArrayList<Tag> filterList = new ArrayList<Tag>(actualMetricId.getTagsAsList());
        filterList.removeIf(tag -> tag.getTagName().equals("_app"));
        Assert.assertThat(filterList, (Matcher)Matchers.containsInAnyOrder((Object[])new Tag[]{new Tag("foo", "bar"), new Tag("tier", "integration")}));
    }

    @Test
    public void customConfigSource() {
        ConfigSource s = new ConfigSource(){

            public Map<String, String> getProperties() {
                return Collections.singletonMap("mp.metrics.tags", "foo=baz");
            }

            public String getValue(String propertyName) {
                return propertyName.equals("mp.metrics.tags") ? "foo=baz" : null;
            }

            public String getName() {
                return "Custom config source";
            }
        };
        Config config = ConfigProviderResolver.instance().getBuilder().withSources(new ConfigSource[]{s}).build();
        GlobalTagsTest.doWithConfig(config, () -> {
            this.registry.counter("mycounter");
            MetricID actualMetricId = this.registry.getCounters().keySet().stream().filter(id -> id.getName().equals("mycounter")).findAny().get();
            Assert.assertThat((Object)actualMetricId.getTagsAsList(), (Matcher)Matchers.containsInAnyOrder((Object[])new Tag[]{new Tag("foo", "baz")}));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWithConfig(Config config, Runnable runnable) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Config originalConfig = ConfigProviderResolver.instance().getConfig();
        try {
            ConfigProviderResolver.instance().releaseConfig(originalConfig);
            ConfigProviderResolver.instance().registerConfig(config, tccl);
            runnable.run();
        }
        finally {
            ConfigProviderResolver.instance().releaseConfig(config);
        }
    }
}

