/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.tck.metrics.SimplyTimedMethodBean1;
import org.eclipse.microprofile.metrics.tck.util.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SimplyTimedMethodBeanLookupTest {
    private static final String SIMPLE_TIMER_NAME = MetricRegistry.name(SimplyTimedMethodBean1.class, (String[])new String[]{"simplyTimedMethod"});
    private static MetricID simpleTimerMID;
    private static final AtomicLong SIMPLE_TIMER_COUNT;
    @Inject
    private MetricRegistry registry;
    @Inject
    private Instance<SimplyTimedMethodBean1> instance;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(SimplyTimedMethodBean1.class)).addClass(TestUtils.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        simpleTimerMID = new MetricID(SIMPLE_TIMER_NAME);
    }

    @Test
    @InSequence(value=1)
    public void simplyTimedMethodNotCalledYet() {
        SimplyTimedMethodBean1 bean = (SimplyTimedMethodBean1)this.instance.get();
        Assert.assertThat((String)"SimplyTimed is not registered correctly", (Object)this.registry.getSimpleTimers(), (Matcher)Matchers.hasKey((Object)simpleTimerMID));
        SimpleTimer simpleTimer = (SimpleTimer)this.registry.getSimpleTimers().get(simpleTimerMID);
        Assert.assertThat((String)"SimplyTimed count is incorrect", (Object)simpleTimer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)SIMPLE_TIMER_COUNT.get())));
    }

    @Test
    @InSequence(value=2)
    public void callSimplyTimedMethodOnce() throws InterruptedException {
        SimplyTimedMethodBean1 bean = (SimplyTimedMethodBean1)this.instance.get();
        Assert.assertThat((String)"SimplyTimed is not registered correctly", (Object)this.registry.getSimpleTimers(), (Matcher)Matchers.hasKey((Object)simpleTimerMID));
        SimpleTimer simpleTimer = (SimpleTimer)this.registry.getSimpleTimers().get(simpleTimerMID);
        bean.simplyTimedMethod();
        Assert.assertThat((String)"SimplyTimed count is incorrect", (Object)simpleTimer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)SIMPLE_TIMER_COUNT.incrementAndGet())));
        TestUtils.assertEqualsWithTolerance(2.0E9, simpleTimer.getElapsedTime().toNanos());
    }

    @Test
    @InSequence(value=3)
    public void removeSimplyTimedFromRegistry() throws InterruptedException {
        SimplyTimedMethodBean1 bean = (SimplyTimedMethodBean1)this.instance.get();
        Assert.assertThat((String)"SimplyTimed is not registered correctly", (Object)this.registry.getSimpleTimers(), (Matcher)Matchers.hasKey((Object)simpleTimerMID));
        SimpleTimer simpleTimer = (SimpleTimer)this.registry.getSimpleTimers().get(simpleTimerMID);
        this.registry.remove(simpleTimerMID);
        try {
            bean.simplyTimedMethod();
        }
        catch (RuntimeException cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class)));
            Assert.assertThat((String)"SimplyTimed count is incorrect", (Object)simpleTimer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)SIMPLE_TIMER_COUNT.get())));
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }

    static {
        SIMPLE_TIMER_COUNT = new AtomicLong();
    }
}

