/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.tck.metrics.TimedMethodBean2;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TimedMethodBeanTest {
    private static final String TIMER_NAME = MetricRegistry.name(TimedMethodBean2.class, (String[])new String[]{"timedMethod"});
    private static MetricID timerMID;
    private static final AtomicLong TIMER_COUNT;
    @Inject
    private MetricRegistry registry;
    @Inject
    private TimedMethodBean2 bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(TimedMethodBean2.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        timerMID = new MetricID(TIMER_NAME);
    }

    @Test
    @InSequence(value=1)
    public void timedMethodNotCalledYet() {
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimers(), (Matcher)Matchers.hasKey((Object)timerMID));
        Timer timer = (Timer)this.registry.getTimers().get(timerMID);
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TIMER_COUNT.get())));
    }

    @Test
    @InSequence(value=2)
    public void callTimedMethodOnce() {
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimers(), (Matcher)Matchers.hasKey((Object)timerMID));
        Timer timer = (Timer)this.registry.getTimers().get(timerMID);
        this.bean.timedMethod();
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TIMER_COUNT.incrementAndGet())));
    }

    @Test
    @InSequence(value=3)
    public void removeTimerFromRegistry() {
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimers(), (Matcher)Matchers.hasKey((Object)timerMID));
        Timer timer = (Timer)this.registry.getTimers().get(timerMID);
        this.registry.remove(timerMID);
        try {
            this.bean.timedMethod();
        }
        catch (RuntimeException cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class)));
            Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TIMER_COUNT.get())));
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }

    static {
        TIMER_COUNT = new AtomicLong();
    }
}

