/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.inheritance;

import java.util.Set;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.inheritance.InheritedSimplyTimedMethodBean;
import org.eclipse.microprofile.metrics.tck.inheritance.VisibilitySimplyTimedMethodBean;
import org.eclipse.microprofile.metrics.tck.util.MetricsUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class InheritedSimplyTimedMethodBeanTest {
    private static final String[] PARENT_SIMPLE_TIMER_NAMES = new String[]{"publicSimplyTimedMethod", "packagePrivateSimplyTimedMethod", "protectedSimplyTimedMethod"};
    private static final String[] CHILD_SIMPLE_TIMER_NAMES = new String[]{"simplyTimedMethodOne", "simplyTimedMethodTwo", "simplyTimedMethodProtected", "simplyTimedMethodPackagedPrivate"};
    @Inject
    private MetricRegistry registry;
    @Inject
    private InheritedSimplyTimedMethodBean bean;

    private Set<String> absoluteMetricNames() {
        Set<String> names = MetricsUtil.absoluteMetricNames(VisibilitySimplyTimedMethodBean.class, PARENT_SIMPLE_TIMER_NAMES);
        names.addAll(MetricsUtil.absoluteMetricNames(InheritedSimplyTimedMethodBean.class, CHILD_SIMPLE_TIMER_NAMES));
        return names;
    }

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{VisibilitySimplyTimedMethodBean.class, InheritedSimplyTimedMethodBean.class, MetricsUtil.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void simplyTimedMethodsNotCalledYet() {
        Assert.assertThat((String)"SimpleTimer are not registered correctly", this.registry.getSimpleTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(MetricsUtil.createMetricIDs(this.absoluteMetricNames()))));
        Assert.assertThat((String)"SimpleTimer counts are incorrect", this.registry.getSimpleTimers().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    @InSequence(value=2)
    public void callSimplyTimedMethodsOnce() {
        Assert.assertThat((String)"SimpleTimer are not registered correctly", this.registry.getSimpleTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(MetricsUtil.createMetricIDs(this.absoluteMetricNames()))));
        this.bean.publicSimplyTimedMethod();
        this.bean.protectedSimplyTimedMethod();
        this.bean.packagePrivateSimplyTimedMethod();
        this.bean.simplyTimedMethodOne();
        this.bean.simplyTimedMethodTwo();
        this.bean.simplyTimedMethodProtected();
        this.bean.simplyTimedMethodPackagedPrivate();
        Assert.assertThat((String)"SimpleTimer counts are incorrect", this.registry.getSimpleTimers().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)1L))));
    }
}

