/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.cdi;

import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.tck.cdi.ApplicationScopedTimedMethodBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ApplicationScopedTimedMethodBeanTest {
    private static final String TIMER_NAME = MetricRegistry.name(ApplicationScopedTimedMethodBean.class, (String[])new String[]{"applicationScopedTimedMethod"});
    private static MetricID timerMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private ApplicationScopedTimedMethodBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(ApplicationScopedTimedMethodBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateApplicationScopedBeanAndTests() {
        this.bean.toString();
        timerMID = new MetricID(TIMER_NAME);
    }

    @Test
    @InSequence(value=1)
    public void timedMethodNotCalledYet() {
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimers(), (Matcher)Matchers.hasKey((Object)timerMID));
        Timer timer = (Timer)this.registry.getTimers().get(timerMID);
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
    }

    @Test
    @InSequence(value=2)
    public void callTimedMethodOnce() {
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimers(), (Matcher)Matchers.hasKey((Object)timerMID));
        Timer timer = (Timer)this.registry.getTimers().get(timerMID);
        this.bean.applicationScopedTimedMethod();
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
    }
}

