/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.metrics;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.tck.metrics.SimplyTimedClassBean;
import org.eclipse.microprofile.metrics.tck.util.MetricsUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SimplyTimedClassBeanTest {
    private static final String CONSTRUCTOR_NAME = "SimplyTimedClassBean";
    private static final String CONSTRUCTOR_SIMPLE_TIMER_NAME = MetricsUtil.absoluteMetricName(SimplyTimedClassBean.class, "simplyTimedClass", "SimplyTimedClassBean");
    private static MetricID constructorMID;
    private static final String[] METHOD_NAMES;
    private static final Set<String> METHOD_SIMPLE_TIMER_NAMES;
    private static final MetricFilter METHOD_SIMPLE_TIMERS;
    private static final Set<String> SIMPLE_TIMER_NAMES;
    private static Set<MetricID> simpleTimerMIDs;
    private static Set<MetricID> simpleTimerMIDsIncludingToString;
    private static final AtomicLong METHOD_COUNT;
    @Inject
    private MetricRegistry registry;
    @Inject
    private SimplyTimedClassBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{SimplyTimedClassBean.class, MetricsUtil.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateApplicationScopedBean() {
        this.bean.toString();
        constructorMID = new MetricID(CONSTRUCTOR_SIMPLE_TIMER_NAME);
        simpleTimerMIDs = MetricsUtil.createMetricIDs(SIMPLE_TIMER_NAMES);
        simpleTimerMIDsIncludingToString = new HashSet<MetricID>();
        simpleTimerMIDsIncludingToString.addAll(simpleTimerMIDs);
        simpleTimerMIDsIncludingToString.addAll(MetricsUtil.createMetricIDs(MetricsUtil.absoluteMetricNames(SimplyTimedClassBean.class, "simplyTimedClass", new String[]{"toString"})));
    }

    @Test
    @InSequence(value=1)
    public void simplyTimedMethodsNotCalledYet() {
        Assert.assertThat((String)"SimpleTimers are not registered correctly", this.registry.getSimpleTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(simpleTimerMIDsIncludingToString)));
        Assert.assertThat((String)"Constructor timer count is incorrect", (Object)((SimpleTimer)this.registry.getSimpleTimers().get(constructorMID)).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Method simple timer counts are incorrect", this.registry.getSimpleTimers(METHOD_SIMPLE_TIMERS).values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)METHOD_COUNT.get()))));
    }

    @Test
    @InSequence(value=2)
    public void callSimplyTimedMethodsOnce() {
        Assert.assertThat((String)"SimpleTimers are not registered correctly", this.registry.getSimpleTimers().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(simpleTimerMIDsIncludingToString)));
        Assert.assertThat((String)"Constructor simple timer count is incorrect", (Object)((SimpleTimer)this.registry.getSimpleTimers().get(constructorMID)).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        this.bean.simplyTimedMethodOne();
        this.bean.simplyTimedMethodTwo();
        this.bean.simplyTimedMethodProtected();
        this.bean.simplyTimedMethodPackagedPrivate();
        Assert.assertThat((String)"Method simple timer counts are incorrect", this.registry.getSimpleTimers(METHOD_SIMPLE_TIMERS).values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)METHOD_COUNT.incrementAndGet()))));
    }

    static {
        METHOD_NAMES = new String[]{"simplyTimedMethodOne", "simplyTimedMethodTwo", "simplyTimedMethodProtected", "simplyTimedMethodPackagedPrivate"};
        METHOD_SIMPLE_TIMER_NAMES = MetricsUtil.absoluteMetricNames(SimplyTimedClassBean.class, "simplyTimedClass", METHOD_NAMES);
        METHOD_SIMPLE_TIMERS = new MetricFilter(){

            public boolean matches(MetricID metricID, Metric metric) {
                return METHOD_SIMPLE_TIMER_NAMES.contains(metricID.getName());
            }
        };
        SIMPLE_TIMER_NAMES = MetricsUtil.absoluteMetricNames(SimplyTimedClassBean.class, "simplyTimedClass", METHOD_NAMES, new String[]{CONSTRUCTOR_NAME});
        METHOD_COUNT = new AtomicLong();
    }
}

