/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.tags;

import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TagsTest {
    @Inject
    private MetricRegistry registry;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void simpleTagTest() {
        Tag one = new Tag("hello", "world");
        Tag two = new Tag("goodbye", "friend");
        MetricID metricID = new MetricID("metricName", new Tag[]{one, two});
        Assert.assertThat((Object)metricID.getTags(), (Matcher)Matchers.hasKey((Object)"hello"));
        Assert.assertThat((Object)metricID.getTags(), (Matcher)Matchers.hasValue((Object)"world"));
        Assert.assertThat((Object)metricID.getTags(), (Matcher)Matchers.hasKey((Object)"goodbye"));
        Assert.assertThat((Object)metricID.getTags(), (Matcher)Matchers.hasValue((Object)"friend"));
        Assert.assertThat((String)"Counter's Global Tag not set properly", (Object)metricID.getTags(), (Matcher)Matchers.hasKey((Object)"tier"));
        Assert.assertThat((String)"Counter's Global Tag not set properly", (Object)metricID.getTags(), (Matcher)Matchers.hasValue((Object)"integration"));
    }

    @Test
    @InSequence(value=2)
    public void lastTagValueTest() {
        Tag tagColour = new Tag("colour", "red");
        Tag tagColourTwo = new Tag("colour", "blue");
        String counterName = "org.eclipse.microprofile.metrics.tck.TagTest.counter";
        Counter counter = this.registry.counter(counterName, new Tag[]{tagColour, tagColourTwo});
        MetricID counterMID = new MetricID(counterName, new Tag[]{tagColourTwo});
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)counterMID));
    }

    @Test
    @InSequence(value=3)
    public void counterTagsTest() {
        Tag tagEarth = new Tag("planet", "earth");
        Tag tagRed = new Tag("colour", "red");
        Tag tagBlue = new Tag("colour", "blue");
        String counterName = "org.eclipse.microprofile.metrics.tck.TagTest.counterColour";
        Counter counterColour = this.registry.counter(counterName);
        Counter counterRed = this.registry.counter(counterName, new Tag[]{tagEarth, tagRed});
        Counter counterBlue = this.registry.counter(counterName, new Tag[]{tagEarth, tagBlue});
        MetricID counterColourMID = new MetricID(counterName);
        MetricID counterRedMID = new MetricID(counterName, new Tag[]{tagEarth, tagRed});
        MetricID counterBlueMID = new MetricID(counterName, new Tag[]{tagEarth, tagBlue});
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)counterColourMID));
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)counterRedMID));
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)counterBlueMID));
    }

    @Test
    @InSequence(value=4)
    public void meterTagsTest() {
        Tag tagEarth = new Tag("planet", "earth");
        Tag tagRed = new Tag("colour", "red");
        Tag tagBlue = new Tag("colour", "blue");
        String meterName = "org.eclipse.microprofile.metrics.tck.TagTest.meterColour";
        Meter meterColour = this.registry.meter(meterName);
        Meter meterRed = this.registry.meter(meterName, new Tag[]{tagEarth, tagRed});
        Meter meterBlue = this.registry.meter(meterName, new Tag[]{tagEarth, tagBlue});
        MetricID meterColourMID = new MetricID(meterName);
        MetricID meterRedMID = new MetricID(meterName, new Tag[]{tagEarth, tagRed});
        MetricID meterBlueMID = new MetricID(meterName, new Tag[]{tagEarth, tagBlue});
        Assert.assertThat((String)"Meter is not registered correctly", (Object)this.registry.getMeters(), (Matcher)Matchers.hasKey((Object)meterColourMID));
        Assert.assertThat((String)"Meter is not registered correctly", (Object)this.registry.getMeters(), (Matcher)Matchers.hasKey((Object)meterRedMID));
        Assert.assertThat((String)"Meter is not registered correctly", (Object)this.registry.getMeters(), (Matcher)Matchers.hasKey((Object)meterBlueMID));
    }

    @Test
    @InSequence(value=5)
    public void timerTagsTest() {
        Tag tagEarth = new Tag("planet", "earth");
        Tag tagRed = new Tag("colour", "red");
        Tag tagBlue = new Tag("colour", "blue");
        String timerName = "org.eclipse.microprofile.metrics.tck.TagTest.timerColour";
        Timer timerColour = this.registry.timer(timerName);
        Timer timerRed = this.registry.timer(timerName, new Tag[]{tagEarth, tagRed});
        Timer timerBlue = this.registry.timer(timerName, new Tag[]{tagEarth, tagBlue});
        MetricID timerColourMID = new MetricID(timerName);
        MetricID timerRedMID = new MetricID(timerName, new Tag[]{tagEarth, tagRed});
        MetricID timerBlueMID = new MetricID(timerName, new Tag[]{tagEarth, tagBlue});
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimers(), (Matcher)Matchers.hasKey((Object)timerColourMID));
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimers(), (Matcher)Matchers.hasKey((Object)timerRedMID));
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimers(), (Matcher)Matchers.hasKey((Object)timerBlueMID));
    }

    @Test
    @InSequence(value=6)
    public void histogramTagsTest() {
        Tag tagEarth = new Tag("planet", "earth");
        Tag tagRed = new Tag("colour", "red");
        Tag tagBlue = new Tag("colour", "blue");
        String histogramName = "org.eclipse.microprofile.metrics.tck.TagTest.histogramColour";
        Histogram histogramColour = this.registry.histogram(histogramName);
        Histogram histogramRed = this.registry.histogram(histogramName, new Tag[]{tagEarth, tagRed});
        Histogram histogramBlue = this.registry.histogram(histogramName, new Tag[]{tagEarth, tagBlue});
        MetricID histogramColourMID = new MetricID(histogramName);
        MetricID histogramRedMID = new MetricID(histogramName, new Tag[]{tagEarth, tagRed});
        MetricID histogramBlueMID = new MetricID(histogramName, new Tag[]{tagEarth, tagBlue});
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistograms(), (Matcher)Matchers.hasKey((Object)histogramColourMID));
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistograms(), (Matcher)Matchers.hasKey((Object)histogramRedMID));
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistograms(), (Matcher)Matchers.hasKey((Object)histogramBlueMID));
    }
}

