/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se.util;

import io.astefanutti.metrics.cdi.se.util.BeanWithControlledInvocation;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ControlledInvocation {
    private final BeanWithControlledInvocation bean;
    private final CountDownLatch startMarker;
    private final CountDownLatch endMarker;
    private final CountDownLatch endCommand;

    public ControlledInvocation(BeanWithControlledInvocation bean) {
        this.bean = bean;
        this.startMarker = new CountDownLatch(1);
        this.endCommand = new CountDownLatch(1);
        this.endMarker = new CountDownLatch(1);
    }

    public void start() throws InterruptedException, TimeoutException {
        new Thread(() -> {
            this.bean.controlledMethod(this.startMarker, this.endCommand);
            this.endMarker.countDown();
        }).start();
        if (!this.startMarker.await(5L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
    }

    public void stop() {
        try {
            if (this.endCommand.getCount() != 0L && this.startMarker.getCount() == 0L) {
                this.endCommand.countDown();
                if (!this.endMarker.await(5L, TimeUnit.SECONDS)) {
                    throw new TimeoutException();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

