/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.ConcurrentGaugedClassBean;
import io.astefanutti.metrics.cdi.se.util.MetricsUtil;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ConcurrentGaugedClassBeanTest {
    private static final String CONSTRUCTOR_NAME = "ConcurrentGaugedClassBean";
    private static final String[] METHOD_NAMES = new String[]{"countedMethodOne", "countedMethodTwo", "countedMethodProtected", "countedMethodPackagedPrivate"};
    private static final Set<String> C_GAUGED_NAMES = MetricsUtil.absoluteMetricNames(ConcurrentGaugedClassBean.class, "cGaugedClass", METHOD_NAMES, new String[]{"ConcurrentGaugedClassBean"});
    private static Set<MetricID> counterMIDs;
    @Inject
    private MetricRegistry registry;
    @Inject
    private ConcurrentGaugedClassBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{ConcurrentGaugedClassBean.class, MetricsUtil.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateTest() {
        counterMIDs = MetricsUtil.createMetricIDs(C_GAUGED_NAMES);
    }

    @Test
    @InSequence(value=1)
    public void countedMethodsNotCalledYet() {
        Assert.assertThat((String)"Counters are not registered correctly", this.registry.getConcurrentGauges().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(counterMIDs)));
        Assert.assertThat((String)"Concurrent Gauges max values are incorrect", this.registry.getConcurrentGauges().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"max", (Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    @InSequence(value=2)
    public void callCountedMethodsOnce() {
        Assert.assertThat((String)"Counters are not registered correctly", this.registry.getConcurrentGauges().keySet(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(counterMIDs)));
        this.bean.countedMethodOne();
        this.bean.countedMethodTwo();
        this.bean.countedMethodProtected();
        this.bean.countedMethodPackagedPrivate();
        Assert.assertThat((String)"Concurrent Gauges counts are incorrect", this.registry.getConcurrentGauges().values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)0L))));
    }
}

