/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.TimedMethodBean2;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TimedMethodBeanTest {
    private static final String TIMER_NAME = MetricRegistry.name(TimedMethodBean2.class, (String[])new String[]{"timedMethod"});
    private static final MetricID TIMER_METRICID = new MetricID(TIMER_NAME);
    private static final AtomicLong TIMER_COUNT = new AtomicLong();
    @Inject
    private MetricRegistry registry;
    @Inject
    private TimedMethodBean2 bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(TimedMethodBean2.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void timedMethodNotCalledYet() {
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimers(), (Matcher)Matchers.hasKey((Object)TIMER_METRICID));
        Timer timer = (Timer)this.registry.getTimers().get(TIMER_METRICID);
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TIMER_COUNT.get())));
    }

    @Test
    @InSequence(value=2)
    public void callTimedMethodOnce() {
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimers(), (Matcher)Matchers.hasKey((Object)TIMER_METRICID));
        Timer timer = (Timer)this.registry.getTimers().get(TIMER_METRICID);
        this.bean.timedMethod();
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TIMER_COUNT.incrementAndGet())));
    }

    @Test
    @InSequence(value=3)
    public void callSelfInvocationTimedMethodOnce() {
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimers(), (Matcher)Matchers.hasKey((Object)TIMER_METRICID));
        Timer timer = (Timer)this.registry.getTimers().get(TIMER_METRICID);
        this.bean.selfInvocationTimedMethod();
        Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TIMER_COUNT.get())));
    }

    @Test
    @InSequence(value=4)
    public void removeTimerFromRegistry() {
        Assert.assertThat((String)"Timer is not registered correctly", (Object)this.registry.getTimers(), (Matcher)Matchers.hasKey((Object)TIMER_METRICID));
        Timer timer = (Timer)this.registry.getTimers().get(TIMER_METRICID);
        this.registry.remove(TIMER_METRICID);
        try {
            this.bean.timedMethod();
        }
        catch (RuntimeException cause) {
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IllegalStateException.class)));
            Assert.assertThat((Object)cause.getMessage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)("No timer with name [" + TIMER_NAME + "] found in registry [" + this.registry + "]"))));
            Assert.assertThat((String)"Timer count is incorrect", (Object)timer.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TIMER_COUNT.get())));
            return;
        }
        Assert.fail((String)"No exception has been re-thrown!");
    }
}

