/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.MetricProducerFieldBean;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MetricProducerFieldBeanTest {
    private static final MetricID COUNTER1_METRICID = new MetricID("counter1");
    private static final MetricID COUNTER2_METRICID = new MetricID("counter2");
    private static final MetricID RATIO_GAUGE_METRICID = new MetricID("ratioGauge");
    private static final MetricID NOTREG_METRICID = new MetricID("not_registered_counter");
    @Inject
    private MetricRegistry registry;
    @Inject
    private MetricProducerFieldBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(MetricProducerFieldBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateApplicationScopedBean() {
        this.bean.toString();
    }

    @Test
    @InSequence(value=1)
    public void countersNotIncrementedYet() {
        Assert.assertThat((String)"Counters are not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)COUNTER1_METRICID), (Matcher)Matchers.hasKey((Object)COUNTER2_METRICID), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)NOTREG_METRICID))));
        Counter counter1 = (Counter)this.registry.getCounters().get(COUNTER1_METRICID);
        Counter counter2 = (Counter)this.registry.getCounters().get(COUNTER2_METRICID);
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)this.registry.getGauges(), (Matcher)Matchers.hasKey((Object)RATIO_GAUGE_METRICID));
        Gauge gauge = (Gauge)this.registry.getGauges().get(RATIO_GAUGE_METRICID);
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((double)counter1.getCount() / (double)counter2.getCount()))));
    }

    @Test
    @InSequence(value=2)
    public void incrementCountersFromRegistry() {
        Assert.assertThat((String)"Counters are not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)COUNTER1_METRICID), (Matcher)Matchers.hasKey((Object)COUNTER2_METRICID), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)NOTREG_METRICID))));
        Counter counter1 = (Counter)this.registry.getCounters().get(COUNTER1_METRICID);
        Counter counter2 = (Counter)this.registry.getCounters().get(COUNTER2_METRICID);
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)this.registry.getGauges(), (Matcher)Matchers.hasKey((Object)RATIO_GAUGE_METRICID));
        Gauge gauge = (Gauge)this.registry.getGauges().get(RATIO_GAUGE_METRICID);
        counter1.inc(Math.round(Math.random() * 2.147483647E9));
        counter2.inc(Math.round(Math.random() * 2.147483647E9));
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((double)counter1.getCount() / (double)counter2.getCount()))));
    }

    @InSequence(value=3)
    public void incrementCountersFromInjection(@Metric(name="ratioGauge", absolute=true) Gauge<Double> gauge, @Metric(name="counter1", absolute=true) Counter counter1, @Metric(name="counter2", absolute=true) Counter counter2) {
        counter1.inc(Math.round(Math.random() * 2.147483647E9));
        counter2.inc(Math.round(Math.random() * 2.147483647E9));
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((double)counter1.getCount() / (double)counter2.getCount()))));
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)this.registry.getGauges(), (Matcher)Matchers.hasKey((Object)"ratioGauge"));
        Gauge gaugeFromRegistry = (Gauge)this.registry.getGauges().get("ratioGauge");
        Assert.assertThat((String)"Gauge values from registry and injection do not match", (Object)gauge.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)gaugeFromRegistry.getValue())));
    }
}

