/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.HistogramTagFieldBean;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class HistogramTagFieldBeanTest {
    private static final String HISTOGRAM_NAME = MetricRegistry.name(HistogramTagFieldBean.class, (String[])new String[]{"histogramName"});
    private static final Tag NUMBER_ONE_TAG = new Tag("number", "one");
    private static final Tag NUMBER_TWO_TAG = new Tag("number", "two");
    private static final MetricID HISTOGRAM_ONE_METRICID = new MetricID(HISTOGRAM_NAME, new Tag[]{NUMBER_ONE_TAG});
    private static final MetricID HISTOGRAM_TWO_METRICID = new MetricID(HISTOGRAM_NAME, new Tag[]{NUMBER_TWO_TAG});
    @Inject
    private MetricRegistry registry;
    @Inject
    private HistogramTagFieldBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(HistogramTagFieldBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void histogramTagFieldRegistered() {
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistograms(), (Matcher)Matchers.hasKey((Object)HISTOGRAM_ONE_METRICID));
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistograms(), (Matcher)Matchers.hasKey((Object)HISTOGRAM_TWO_METRICID));
    }

    @Test
    @InSequence(value=2)
    public void updateHistogramTagField() {
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistograms(), (Matcher)Matchers.hasKey((Object)HISTOGRAM_ONE_METRICID));
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistograms(), (Matcher)Matchers.hasKey((Object)HISTOGRAM_TWO_METRICID));
        Histogram histogramOne = (Histogram)this.registry.getHistograms().get(HISTOGRAM_ONE_METRICID);
        Histogram histogramTwo = (Histogram)this.registry.getHistograms().get(HISTOGRAM_TWO_METRICID);
        long value = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.updateOne(value);
        long valueTwo = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.updateTwo(valueTwo);
        Assert.assertThat((String)"Histogram count is incorrect", (Object)histogramOne.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Histogram size is incorrect", (Object)histogramOne.getSnapshot().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Assert.assertThat((String)"Histogram min value is incorrect", (Object)histogramOne.getSnapshot().getMin(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
        Assert.assertThat((String)"Histogram max value is incorrect", (Object)histogramOne.getSnapshot().getMax(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
        Assert.assertThat((String)"Histogram count is incorrect", (Object)histogramTwo.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Histogram size is incorrect", (Object)histogramTwo.getSnapshot().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Assert.assertThat((String)"Histogram min value is incorrect", (Object)histogramTwo.getSnapshot().getMin(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)valueTwo)));
        Assert.assertThat((String)"Histogram max value is incorrect", (Object)histogramTwo.getSnapshot().getMax(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)valueTwo)));
    }
}

