/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.GaugeTagMethodBean;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class GaugeTagMethodBeanTest {
    private static final String GAUGE_NAME = MetricRegistry.name(GaugeTagMethodBean.class, (String[])new String[]{"gaugeMethod"});
    private static final Tag NUMBER_ONE_TAG = new Tag("number", "one");
    private static final Tag NUMBER_TWO_TAG = new Tag("number", "two");
    private static final MetricID GAUGE_ONE_METRICID = new MetricID(GAUGE_NAME, new Tag[]{NUMBER_ONE_TAG});
    private static final MetricID GAUGE_TWO_METRICID = new MetricID(GAUGE_NAME, new Tag[]{NUMBER_TWO_TAG});
    @Inject
    private MetricRegistry registry;
    @Inject
    private GaugeTagMethodBean bean;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(GaugeTagMethodBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void instantiateApplicationScopedBean() {
        this.bean.getGaugeOne();
        this.bean.getGaugeTwo();
    }

    @Test
    @InSequence(value=1)
    public void gaugeTagCalledWithDefaultValue() {
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)this.registry.getGauges(), (Matcher)Matchers.hasKey((Object)GAUGE_ONE_METRICID));
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)this.registry.getGauges(), (Matcher)Matchers.hasKey((Object)GAUGE_TWO_METRICID));
        Gauge gaugeOne = (Gauge)this.registry.getGauges().get(GAUGE_ONE_METRICID);
        Gauge gaugeTwo = (Gauge)this.registry.getGauges().get(GAUGE_TWO_METRICID);
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gaugeOne.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gaugeTwo.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
    }

    @Test
    @InSequence(value=2)
    public void callGaugeTagAfterSetterCall() {
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)this.registry.getGauges(), (Matcher)Matchers.hasKey((Object)GAUGE_ONE_METRICID));
        Assert.assertThat((String)"Gauge is not registered correctly", (Object)this.registry.getGauges(), (Matcher)Matchers.hasKey((Object)GAUGE_TWO_METRICID));
        Gauge gaugeOne = (Gauge)this.registry.getGauges().get(GAUGE_ONE_METRICID);
        Gauge gaugeTwo = (Gauge)this.registry.getGauges().get(GAUGE_TWO_METRICID);
        long value = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.setGaugeOne(value);
        long secondValue = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.setGaugeTwo(secondValue);
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gaugeOne.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
        Assert.assertThat((String)"Gauge value is incorrect", (Object)gaugeTwo.getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)secondValue)));
    }
}

