/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.CounterFieldTagBean;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CounterFieldTagBeanTest {
    private static final String COUNTER_NAME = MetricRegistry.name(CounterFieldTagBean.class, (String[])new String[]{"counterName"});
    private static final Tag NUMBER_TWO_TAG = new Tag("number", "two");
    private static final Tag NUMBER_THREE_TAG = new Tag("number", "three");
    private static final Tag COLOUR_RED_TAG = new Tag("colour", "red");
    private static final Tag COLOUR_BLUE_TAG = new Tag("colour", "blue");
    private static final MetricID COUNTER_MID = new MetricID(COUNTER_NAME);
    private static final MetricID COUNTER_TWO_MID = new MetricID(COUNTER_NAME, new Tag[]{NUMBER_TWO_TAG, COLOUR_RED_TAG});
    private static final MetricID COUNTER_THREE_MID = new MetricID(COUNTER_NAME, new Tag[]{NUMBER_THREE_TAG, COLOUR_BLUE_TAG});
    @Inject
    private MetricRegistry registry;
    @Inject
    private CounterFieldTagBean bean;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(CounterFieldTagBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void counterTagFieldsRegistered() {
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_MID));
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_TWO_MID));
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_THREE_MID));
    }

    @Test
    @InSequence(value=2)
    public void incrementCounterTagFields() {
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_MID));
        Counter counterOne = (Counter)this.registry.getCounters().get(COUNTER_MID);
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_TWO_MID));
        Counter counterTwo = (Counter)this.registry.getCounters().get(COUNTER_TWO_MID);
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_THREE_MID));
        Counter counterThree = (Counter)this.registry.getCounters().get(COUNTER_THREE_MID);
        long value = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.incrementOne(value);
        long valueTwo = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.incrementTwo(valueTwo);
        long valueThree = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.incrementThree(valueThree);
        Assert.assertThat((String)"Counter value is incorrect", (Object)counterOne.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
        Assert.assertThat((String)"Counter value is incorrect", (Object)counterTwo.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)valueTwo)));
        Assert.assertThat((String)"Counter value is incorrect", (Object)counterThree.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)valueThree)));
    }
}

