/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.ConcurrentGaugedConstructorBean;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ConcurrentGaugedConstructorBeanTest {
    private static final String COUNTER_NAME = MetricRegistry.name(ConcurrentGaugedConstructorBean.class, (String[])new String[]{"cGaugedConstructor"});
    private static final MetricID COUNTER_METRICID = new MetricID(COUNTER_NAME);
    @Inject
    private MetricRegistry registry;
    @Inject
    private Instance<ConcurrentGaugedConstructorBean> instance;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(ConcurrentGaugedConstructorBean.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void countedConstructorCalled() {
        long count = 1L + Math.round(Math.random() * 10.0);
        int i = 0;
        while ((long)i < count) {
            this.instance.get();
            ++i;
        }
        Assert.assertThat((String)"Concurrent Gauge is not registered correctly", (Object)this.registry.getConcurrentGauges(), (Matcher)Matchers.hasKey((Object)COUNTER_METRICID));
        ConcurrentGauge concurrentGauge = (ConcurrentGauge)this.registry.getConcurrentGauges().get(COUNTER_METRICID);
        Assert.assertThat((String)"Concurrent gauge max is incorrect", (Object)concurrentGauge.getMax(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)count)));
        Assert.assertThat((String)"Concurrent gauge min is incorrect", (Object)concurrentGauge.getMin(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
        Assert.assertThat((String)"Concurrent gauge count is incorrect", (Object)concurrentGauge.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }
}

