/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck;

import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.tck.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MeterTest {
    @Inject
    private Meter injectedMeter;
    @Inject
    private MetricRegistry registry;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(TestUtils.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testCount() throws Exception {
        long countBefore = this.injectedMeter.getCount();
        this.injectedMeter.mark();
        long countAfter = this.injectedMeter.getCount();
        Assert.assertEquals((long)(countBefore + 1L), (long)countAfter);
        countBefore = this.injectedMeter.getCount();
        this.injectedMeter.mark(2L);
        countAfter = this.injectedMeter.getCount();
        Assert.assertEquals((long)(countBefore + 2L), (long)countAfter);
        countBefore = this.injectedMeter.getCount();
        this.injectedMeter.mark(-3L);
        countAfter = this.injectedMeter.getCount();
        Assert.assertEquals((long)(countBefore - 3L), (long)countAfter);
    }

    @Test
    public void testRates() throws Exception {
        int count = 100;
        int markSeconds = 30;
        int delaySeconds = 15;
        Meter meter = this.registry.meter("testMeterRatesLong");
        for (int i = 0; i < markSeconds; ++i) {
            meter.mark((long)count);
            Thread.sleep(1000L);
        }
        TestUtils.assertEqualsWithTolerance(count, meter.getMeanRate());
        TestUtils.assertEqualsWithTolerance(count, meter.getOneMinuteRate());
        TestUtils.assertEqualsWithTolerance(count, meter.getFiveMinuteRate());
        TestUtils.assertEqualsWithTolerance(count, meter.getFifteenMinuteRate());
        Thread.sleep(delaySeconds * 1000);
        double expectedMean = (double)count * ((double)markSeconds / (double)(markSeconds + delaySeconds));
        TestUtils.assertEqualsWithTolerance(expectedMean, meter.getMeanRate());
        Assert.assertThat((Object)meter.getOneMinuteRate(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(count)));
        Assert.assertThat((Object)meter.getFiveMinuteRate(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(count)));
        Assert.assertThat((Object)meter.getFifteenMinuteRate(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(count)));
    }
}

