/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck;

import java.util.Arrays;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TimerTest {
    @Inject
    private MetricRegistry registry;
    private static Timer globalTimer = null;
    private static boolean isInitialized = false;
    static final long[] SAMPLE_LONG_DATA = new long[]{0L, 10L, 20L, 20L, 20L, 30L, 30L, 30L, 30L, 30L, 40L, 50L, 50L, 60L, 70L, 70L, 70L, 80L, 90L, 90L, 100L, 110L, 110L, 120L, 120L, 120L, 120L, 130L, 130L, 130L, 130L, 140L, 140L, 150L, 150L, 170L, 180L, 180L, 200L, 200L, 200L, 210L, 220L, 220L, 220L, 240L, 240L, 250L, 250L, 270L, 270L, 270L, 270L, 270L, 270L, 270L, 280L, 280L, 290L, 300L, 310L, 310L, 320L, 320L, 330L, 330L, 360L, 360L, 360L, 360L, 370L, 380L, 380L, 380L, 390L, 400L, 400L, 410L, 420L, 420L, 420L, 430L, 440L, 440L, 440L, 450L, 450L, 450L, 460L, 460L, 460L, 460L, 470L, 470L, 470L, 470L, 470L, 470L, 480L, 480L, 490L, 490L, 500L, 510L, 520L, 520L, 520L, 530L, 540L, 540L, 550L, 560L, 560L, 570L, 570L, 590L, 590L, 600L, 610L, 610L, 620L, 620L, 630L, 640L, 640L, 640L, 650L, 660L, 660L, 660L, 670L, 670L, 680L, 680L, 700L, 710L, 710L, 710L, 710L, 720L, 720L, 720L, 720L, 730L, 730L, 740L, 740L, 740L, 750L, 750L, 760L, 760L, 760L, 770L, 780L, 780L, 780L, 800L, 800L, 810L, 820L, 820L, 820L, 830L, 830L, 840L, 840L, 850L, 870L, 870L, 880L, 880L, 880L, 890L, 890L, 890L, 890L, 900L, 910L, 920L, 920L, 920L, 930L, 940L, 950L, 950L, 950L, 960L, 960L, 960L, 960L, 970L, 970L, 970L, 970L, 980L, 980L, 980L, 990L, 990L};

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void initData() {
        if (isInitialized) {
            return;
        }
        globalTimer = this.registry.timer("test.longData.timer");
        for (long i : SAMPLE_LONG_DATA) {
            globalTimer.update(i, TimeUnit.NANOSECONDS);
        }
        isInitialized = true;
    }

    @Test
    @InSequence(value=1)
    public void testRates() throws Exception {
        double beforeStartTime = System.nanoTime();
        Timer timer = this.registry.timer("testRate");
        double afterStartTime = System.nanoTime();
        Timer.Context context = timer.time();
        context.stop();
        Thread.sleep(10000L);
        double beforeUptime = (double)System.nanoTime() - afterStartTime;
        double mean = timer.getMeanRate() / (double)TimeUnit.SECONDS.toNanos(1L);
        double afterUptime = (double)System.nanoTime() - beforeStartTime;
        double delta = 1.0 / beforeUptime - 1.0 / afterUptime;
        Assert.assertEquals((double)(1.0 / beforeUptime), (double)mean, (double)delta);
        Assert.assertEquals((double)0.184, (double)timer.getOneMinuteRate(), (double)0.001);
        Assert.assertEquals((double)0.196, (double)timer.getFiveMinuteRate(), (double)0.001);
        Assert.assertEquals((double)0.198, (double)timer.getFifteenMinuteRate(), (double)0.001);
    }

    @Test
    @InSequence(value=2)
    public void testTime() throws Exception {
        Timer timer = this.registry.timer("testTime");
        double beforeStartTime = System.nanoTime();
        Timer.Context context = timer.time();
        double afterStartTime = System.nanoTime();
        double beforeStopTime = System.nanoTime();
        double time = context.stop();
        double afterStopTime = System.nanoTime();
        Thread.sleep(10000L);
        double delta = afterStartTime - beforeStartTime + (afterStopTime - beforeStopTime);
        Assert.assertEquals((double)(beforeStopTime - beforeStartTime), (double)time, (double)delta);
    }

    @Test
    @InSequence(value=3)
    public void testTimerRegistry() throws Exception {
        String timerLongName = "test.longData.timer";
        String timerRateName = "testRate";
        String timerTimeName = "testTime";
        SortedMap timers = this.registry.getTimers();
        Assert.assertTrue((timers.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)timers.containsKey(timerLongName));
        Assert.assertTrue((boolean)timers.containsKey(timerTimeName));
        Assert.assertEquals((float)1.0f, (float)((Timer)timers.get(timerRateName)).getCount(), (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)this.registry.timer("testRate").getCount(), (float)0.0f);
        Assert.assertEquals((double)480.0, (double)((Timer)timers.get(timerLongName)).getSnapshot().getValue(0.5), (double)0.0);
    }

    @Test
    @InSequence(value=4)
    public void timesCallableInstances() throws Exception {
        Timer timer = this.registry.timer("testCallable");
        String value = (String)timer.time(() -> "one");
        Assert.assertEquals((long)timer.getCount(), (long)1L);
        Assert.assertEquals((Object)value, (Object)"one");
    }

    @Test
    @InSequence(value=5)
    public void timesRunnableInstances() throws Exception {
        Timer timer = this.registry.timer("testRunnable");
        AtomicBoolean called = new AtomicBoolean();
        timer.time(() -> called.set(true));
        Assert.assertEquals((long)timer.getCount(), (long)1L);
        Assert.assertEquals((Object)called.get(), (Object)true);
    }

    @Test
    public void testSnapshotValues() throws Exception {
        Assert.assertArrayEquals((String)("The globalTimer does not contain the expected values: " + Arrays.toString(SAMPLE_LONG_DATA)), (long[])SAMPLE_LONG_DATA, (long[])globalTimer.getSnapshot().getValues());
    }

    @Test
    public void testSnapshot75thPercentile() throws Exception {
        Assert.assertEquals((double)750.0, (double)globalTimer.getSnapshot().get75thPercentile(), (double)0.0);
    }

    @Test
    public void testSnapshot95thPercentile() throws Exception {
        Assert.assertEquals((double)960.0, (double)globalTimer.getSnapshot().get95thPercentile(), (double)0.0);
    }

    @Test
    public void testSnapshot98thPercentile() throws Exception {
        Assert.assertEquals((double)980.0, (double)globalTimer.getSnapshot().get98thPercentile(), (double)0.0);
    }

    @Test
    public void testSnapshot99thPercentile() throws Exception {
        Assert.assertEquals((double)980.0, (double)globalTimer.getSnapshot().get99thPercentile(), (double)0.0);
    }

    @Test
    public void testSnapshot999thPercentile() throws Exception {
        Assert.assertEquals((double)990.0, (double)globalTimer.getSnapshot().get999thPercentile(), (double)0.0);
    }

    @Test
    public void testSnapshotMax() throws Exception {
        Assert.assertEquals((double)990.0, (double)globalTimer.getSnapshot().getMax(), (double)0.0);
    }

    @Test
    public void testSnapshotMin() throws Exception {
        Assert.assertEquals((double)0.0, (double)globalTimer.getSnapshot().getMin(), (double)0.0);
    }

    @Test
    public void testSnapshotMean() throws Exception {
        Assert.assertEquals((double)506.3, (double)globalTimer.getSnapshot().getMean(), (double)0.1);
    }

    @Test
    public void testSnapshotMedian() throws Exception {
        Assert.assertEquals((double)480.0, (double)globalTimer.getSnapshot().getMedian(), (double)0.0);
    }

    @Test
    public void testSnapshotStdDev() throws Exception {
        Assert.assertEquals((double)294.3, (double)globalTimer.getSnapshot().getStdDev(), (double)0.1);
    }

    @Test
    public void testSnapshotSize() throws Exception {
        Assert.assertEquals((double)200.0, (double)globalTimer.getSnapshot().size(), (double)0.0);
    }
}

