/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.MeteredClassBean;
import io.astefanutti.metrics.cdi.se.util.MetricsUtil;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MeteredClassBeanTest {
    private static final String CONSTRUCTOR_NAME = "MeteredClassBean";
    private static final String CONSTRUCTOR_METER_NAME = MetricsUtil.absoluteMetricName(MeteredClassBean.class, "meteredClass", "MeteredClassBean");
    private static final String[] METHOD_NAMES = new String[]{"meteredMethodOne", "meteredMethodTwo", "meteredMethodProtected", "meteredMethodPackagedPrivate"};
    private static final Set<String> METHOD_METER_NAMES = MetricsUtil.absoluteMetricNames(MeteredClassBean.class, "meteredClass", METHOD_NAMES);
    private static final MetricFilter METHOD_METERS = new MetricFilter(){

        public boolean matches(String name, Metric metric) {
            return METHOD_METER_NAMES.contains(name);
        }
    };
    private static final Set<String> METER_NAMES = MetricsUtil.absoluteMetricNames(MeteredClassBean.class, "meteredClass", METHOD_NAMES, new String[]{"MeteredClassBean"});
    private static final AtomicLong CONSTRUCTOR_COUNT = new AtomicLong();
    private static final AtomicLong METHOD_COUNT = new AtomicLong();
    @Inject
    private MetricRegistry registry;
    @Inject
    private MeteredClassBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{MeteredClassBean.class, MetricsUtil.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void meteredMethodsNotCalledYet() {
        Assert.assertTrue((String)"Meters are not registered correctly", (boolean)this.registry.getMeters().keySet().containsAll(METER_NAMES));
        Assert.assertThat((String)"Constructor meter count is incorrect", (Object)((Meter)this.registry.getMeters().get(CONSTRUCTOR_METER_NAME)).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)CONSTRUCTOR_COUNT.incrementAndGet())));
        Assert.assertThat((String)"Method meter counts are incorrect", this.registry.getMeters(METHOD_METERS).values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)METHOD_COUNT.get()))));
    }

    @Test
    @InSequence(value=2)
    public void callMeteredMethodsOnce() {
        Assert.assertTrue((String)"Meters are not registered correctly", (boolean)this.registry.getMeters().keySet().containsAll(METER_NAMES));
        Assert.assertThat((String)"Constructor meter count is incorrect", (Object)((Meter)this.registry.getMeters().get(CONSTRUCTOR_METER_NAME)).getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)CONSTRUCTOR_COUNT.incrementAndGet())));
        this.bean.meteredMethodOne();
        this.bean.meteredMethodTwo();
        this.bean.meteredMethodProtected();
        this.bean.meteredMethodPackagedPrivate();
        Assert.assertThat((String)"Method meter counts are incorrect", this.registry.getMeters(METHOD_METERS).values(), (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"count", (Matcher)Matchers.equalTo((Object)METHOD_COUNT.incrementAndGet()))));
    }
}

