/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.cdi.se;

import io.astefanutti.metrics.cdi.se.CountedConstructorBean;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CountedConstructorBeanTest {
    private static final String COUNTER_NAME = MetricRegistry.name(CountedConstructorBean.class, (String[])new String[]{"countedConstructor"});
    @Inject
    private MetricRegistry registry;
    @Inject
    private Instance<CountedConstructorBean> instance;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(CountedConstructorBean.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void countedConstructorCalled() {
        long count = 1L + Math.round(Math.random() * 10.0);
        int i = 0;
        while ((long)i < count) {
            this.instance.get();
            ++i;
        }
        Assert.assertThat((String)"Counter is not registered correctly", (Object)this.registry.getCounters(), (Matcher)Matchers.hasKey((Object)COUNTER_NAME));
        Counter counter = (Counter)this.registry.getCounters().get(COUNTER_NAME);
        Assert.assertThat((String)"Counter count is incorrect", (Object)counter.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)count)));
    }
}

