/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MeterTest {
    @Inject
    private Meter injectedMeter;
    @Inject
    private MetricRegistry registry;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void testCount() throws Exception {
        long countBefore = this.injectedMeter.getCount();
        this.injectedMeter.mark();
        long countAfter = this.injectedMeter.getCount();
        Assert.assertEquals((long)(countBefore + 1L), (long)countAfter);
        countBefore = this.injectedMeter.getCount();
        this.injectedMeter.mark(2L);
        countAfter = this.injectedMeter.getCount();
        Assert.assertEquals((long)(countBefore + 2L), (long)countAfter);
        countBefore = this.injectedMeter.getCount();
        this.injectedMeter.mark(-3L);
        countAfter = this.injectedMeter.getCount();
        Assert.assertEquals((long)(countBefore - 3L), (long)countAfter);
    }

    private void verifyMeanRate(Meter meter, double beforeStartTime, double afterStartTime, int count) {
        double beforeUptime = (double)System.nanoTime() - afterStartTime;
        double rate = meter.getMeanRate() / (double)TimeUnit.SECONDS.toNanos(1L);
        double afterUptime = (double)System.nanoTime() - beforeStartTime;
        double delta = (double)count / beforeUptime - (double)count / afterUptime;
        Assert.assertEquals((double)((double)count / beforeUptime), (double)rate, (double)delta);
    }

    public void testRates() throws Exception {
        int count = 9999;
        double beforeStartTime = System.nanoTime();
        Meter meter = this.registry.meter("testMeterRates1");
        double afterStartTime = System.nanoTime();
        meter.mark((long)count);
        Thread.sleep(10000L);
        this.verifyMeanRate(meter, beforeStartTime, afterStartTime, count);
        Assert.assertEquals((double)1839.904, (double)meter.getOneMinuteRate(), (double)0.001);
        Assert.assertEquals((double)1966.746, (double)meter.getFiveMinuteRate(), (double)0.001);
        Assert.assertEquals((double)1988.72, (double)meter.getFifteenMinuteRate(), (double)0.001);
        count = 1;
        beforeStartTime = System.nanoTime();
        meter = this.registry.meter("testMeterRates2");
        afterStartTime = System.nanoTime();
        meter.mark();
        Thread.sleep(10000L);
        this.verifyMeanRate(meter, beforeStartTime, afterStartTime, count);
        Assert.assertEquals((double)0.184, (double)meter.getOneMinuteRate(), (double)0.001);
        Assert.assertEquals((double)0.196, (double)meter.getFiveMinuteRate(), (double)0.001);
        Assert.assertEquals((double)0.198, (double)meter.getFifteenMinuteRate(), (double)0.001);
        count = 2000000000;
        beforeStartTime = System.nanoTime();
        meter = this.registry.meter("testMeterRates3");
        afterStartTime = System.nanoTime();
        meter.mark((long)count);
        Thread.sleep(10000L);
        this.verifyMeanRate(meter, beforeStartTime, afterStartTime, count);
        Assert.assertEquals((double)3.68017765851E8, (double)meter.getOneMinuteRate(), (double)0.001);
        Assert.assertEquals((double)3.93388581528E8, (double)meter.getFiveMinuteRate(), (double)0.001);
        Assert.assertEquals((double)3.97783939201E8, (double)meter.getFifteenMinuteRate(), (double)0.001);
    }
}

