/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.tck.Location;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigPropertiesTest
extends Arquillian {
    @Inject
    InjectingBean bean;

    @Deployment
    public static WebArchive deploy() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ConfigPropertiesTest.war")).addClasses(new Class[]{ConfigPropertiesTest.class, BeanOne.class, BeanTwo.class, BeanThree.class, BeanFour.class, Location.class})).addAsResource((Asset)new StringAsset("customer.name=Bob\ncustomer.age=24\ncustomer.location=2 Hook Road, Winchester, Hampshire, SO21 2JN, UK\ncustomer.job=Developer\ncustomer.new.hobbies=Badminton,Tennis\nclient.name=Rob\nclient.age=25\nclient.location=22 Hook Road, Winchester, Hampshire, SO21 2JN, UK\nclient.job=Engineer\nclient.new.hobbies=Football,Tennis\nname=Harry\nage=21\nnationality=UK\nlocation=222 Hook Road, Winchester, Hampshire, SO21 2JN, UK\njob=Plumber\nnew.hobbies=Volleyball\nhost=localhost\nport=9080\nendpoint=woof\nmy.host=myhost\nmy.port=9081\nmy.endpoint=poof\nother.name=Holly\nother.age=20\nother.nationality=USA\n"), "META-INF/microprofile-config.properties")).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testConfigPropertiesPlainInjection() {
        BeanOne customerBeanOne = this.bean.getCustomerBeanOne();
        Assert.assertEquals((String)customerBeanOne.getName(), (String)"Bob");
        Assert.assertEquals((int)customerBeanOne.age, (int)24);
        Assert.assertEquals((String)customerBeanOne.job, (String)"Developer");
        Assert.assertEquals((Object[])customerBeanOne.hobbies, (Object[])new String[]{"Badminton", "Tennis"});
        Assert.assertEquals((Object)customerBeanOne.location, (Object)new Location("2 Hook Road, Winchester, Hampshire, SO21 2JN, UK"));
    }

    @Test
    public void testConfigPropertiesWithPrefix() {
        BeanOne clientBeanOne = this.bean.getClientBeanOne();
        Assert.assertEquals((String)clientBeanOne.getName(), (String)"Rob");
        Assert.assertEquals((int)clientBeanOne.age, (int)25);
        Assert.assertEquals((String)clientBeanOne.job, (String)"Engineer");
        Assert.assertEquals((Object[])clientBeanOne.hobbies, (Object[])new String[]{"Football", "Tennis"});
        Assert.assertEquals((Object)clientBeanOne.location, (Object)new Location("22 Hook Road, Winchester, Hampshire, SO21 2JN, UK"));
        BeanOne bo = (BeanOne)CDI.current().select(BeanOne.class, new Annotation[]{ConfigProperties.Literal.of((String)"client")}).get();
        Assert.assertEquals((String)bo.getName(), (String)"Rob");
        Assert.assertEquals((int)bo.age, (int)25);
        Assert.assertEquals((String)bo.job, (String)"Engineer");
        Assert.assertEquals((Object[])bo.hobbies, (Object[])new String[]{"Football", "Tennis"});
        Assert.assertEquals((Object)bo.location, (Object)new Location("22 Hook Road, Winchester, Hampshire, SO21 2JN, UK"));
    }

    @Test
    public void testConfigPropertiesWithoutPrefix() {
        BeanOne beanOne = this.bean.getBeanOne();
        Assert.assertEquals((String)beanOne.getName(), (String)"Harry");
        Assert.assertEquals((int)beanOne.age, (int)21);
        Assert.assertEquals((String)beanOne.job, (String)"Plumber");
        Assert.assertEquals((Object[])beanOne.hobbies, (Object[])new String[]{"Volleyball"});
        Assert.assertEquals((Object)beanOne.location, (Object)new Location("222 Hook Road, Winchester, Hampshire, SO21 2JN, UK"));
        BeanOne bo = (BeanOne)CDI.current().select(BeanOne.class, new Annotation[]{ConfigProperties.Literal.of((String)"")}).get();
        Assert.assertEquals((String)bo.getName(), (String)"Harry");
        Assert.assertEquals((int)bo.age, (int)21);
        Assert.assertEquals((String)bo.job, (String)"Plumber");
        Assert.assertEquals((Object[])bo.hobbies, (Object[])new String[]{"Volleyball"});
        Assert.assertEquals((Object)bo.location, (Object)new Location("222 Hook Road, Winchester, Hampshire, SO21 2JN, UK"));
    }

    @Test
    public void testConfigPropertiesNoPrefixOnBean() {
        BeanTwo beanTwo = this.bean.getBeanTwo();
        Assert.assertEquals((String)beanTwo.getHost(), (String)"localhost");
        Assert.assertEquals((int)beanTwo.port, (int)9080);
        Assert.assertEquals((String)beanTwo.endpoint, (String)"woof");
    }

    @Test
    public void testConfigPropertiesNoPrefixOnBeanThenSupplyPrefix() {
        BeanTwo myBeanTwo = this.bean.getMyBeanTwo();
        Assert.assertEquals((String)myBeanTwo.getHost(), (String)"myhost");
        Assert.assertEquals((int)myBeanTwo.port, (int)9081);
        Assert.assertEquals((String)myBeanTwo.endpoint, (String)"poof");
    }

    @Test
    public void testNoConfigPropertiesAnnotationInjection() {
        BeanThree beanThree = this.bean.getBeanThree();
        Assert.assertNull((Object)beanThree.name);
        Assert.assertEquals((int)beanThree.age, (int)0);
        Assert.assertNull((Object)beanThree.getNationality());
    }

    @Test
    public void testConfigPropertiesDefaultOnBean() {
        BeanFour myBeanFour = this.bean.getMyBeanFour();
        Assert.assertEquals((String)myBeanFour.getHost(), (String)"mycloud.org");
        Assert.assertEquals((int)myBeanFour.port, (int)9080);
        Assert.assertFalse((boolean)myBeanFour.location.isPresent());
    }

    @Dependent
    public static class InjectingBean {
        @Inject
        @ConfigProperties
        private BeanOne customerBeanOne;
        @Inject
        @ConfigProperties(prefix="client")
        private BeanOne clientBeanOne;
        @Inject
        @ConfigProperties(prefix="")
        private BeanOne beanOne;
        @Inject
        @ConfigProperties
        private BeanTwo beanTwo;
        @Inject
        @ConfigProperties(prefix="my")
        private BeanTwo myBeanTwo;
        @Inject
        @ConfigProperties
        private BeanFour myBeanFour;
        @Inject
        private BeanThree beanThree;

        public BeanOne getCustomerBeanOne() {
            return this.customerBeanOne;
        }

        public BeanOne getClientBeanOne() {
            return this.clientBeanOne;
        }

        public BeanOne getBeanOne() {
            return this.beanOne;
        }

        public BeanTwo getBeanTwo() {
            return this.beanTwo;
        }

        public BeanTwo getMyBeanTwo() {
            return this.myBeanTwo;
        }

        public BeanFour getMyBeanFour() {
            return this.myBeanFour;
        }

        public BeanThree getBeanThree() {
            return this.beanThree;
        }
    }

    @ConfigProperties(prefix="cloud")
    @Dependent
    public static class BeanFour {
        @ConfigProperty(name="a.host", defaultValue="mycloud.org")
        private String host;
        public int port = 9080;
        public Optional<String> location;

        public String getHost() {
            return this.host;
        }
    }

    @Dependent
    public static class BeanThree {
        public String name;
        public int age;
        private String nationality;

        public String getNationality() {
            return this.nationality;
        }
    }

    @ConfigProperties
    @RequestScoped
    public static class BeanTwo {
        private String host;
        int port;
        String endpoint;

        public String getHost() {
            return this.host;
        }
    }

    @ConfigProperties(prefix="customer")
    @Dependent
    public static class BeanOne {
        private String name;
        int age;
        public Location location;
        protected String job;
        @ConfigProperty(name="new.hobbies")
        public String[] hobbies;

        public String getName() {
            return this.name;
        }
    }
}

