/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck.configsources;

import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DefaultConfigSourceOrdinalTest
extends Arquillian {
    @Inject
    private Config config;

    @Deployment
    public static Archive deployment() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"DefaultConfigSourceOrdinalTest.jar")).addClasses(new Class[]{DefaultConfigSourceOrdinalTest.class})).addAsManifestResource((Asset)new StringAsset("config_ordinal=200\ncustomer_name=Bill\ncustomer.hobby=Badminton"), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"DefaultConfigSourceOrdinalTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @BeforeClass
    public void checkSetup() {
        if (!"45".equals(System.getenv("config_ordinal"))) {
            Assert.fail((String)"Before running this test, the environment variable \"config_ordinal\" must be set with the value of 45");
        }
        if (!"Bob".equals(System.getenv("customer_name"))) {
            Assert.fail((String)"Before running this test, the environment variable \"customer_name\" must be set with the value of Bob");
        }
        System.setProperty("customer.hobby", "Tennis");
        System.setProperty("config_ordinal", "120");
    }

    @Test
    public void testOrdinalForEnv() {
        Assert.assertEquals((Object)"Bill", (Object)this.config.getValue("customer_name", String.class));
        Assert.assertEquals((long)200L, (long)this.config.getConfigValue("customer_name").getSourceOrdinal());
    }

    @Test
    public void testOrdinalForSystemProps() {
        Assert.assertEquals((Object)"Badminton", (Object)this.config.getValue("customer.hobby", String.class));
        Assert.assertEquals((long)200L, (long)this.config.getConfigValue("customer.hobby").getSourceOrdinal());
    }
}

