/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck.profile;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class DevConfigProfileTest
extends Arquillian {
    @Deployment
    public static Archive deployment() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"DevConfigProfileTest.jar")).addClasses(new Class[]{DevConfigProfileTest.class, ProfilePropertyBean.class})).addAsManifestResource((Asset)new StringAsset("mp.config.profile=dev\n%dev.vehicle.name=bike\n%prod.vehicle.name=bus\n%test.vehicle.name=van\nvehicle.name=car"), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"DevConfigProfileTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testConfigProfileWithDev() {
        ProfilePropertyBean bean = (ProfilePropertyBean)CDI.current().select(ProfilePropertyBean.class, new Annotation[0]).get();
        MatcherAssert.assertThat((Object)bean.getConfigProperty(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bike")));
        MatcherAssert.assertThat((Object)ConfigProvider.getConfig().getValue("vehicle.name", String.class), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bike")));
    }

    @Dependent
    public static class ProfilePropertyBean {
        @Inject
        @ConfigProperty(name="vehicle.name")
        private String vehicleName;

        public String getConfigProperty() {
            return this.vehicleName;
        }
    }
}

