/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck.profile;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.testng.annotations.Test;

public class ConfigPropertyFileProfileTest
extends Arquillian {
    @Deployment
    public static Archive deployment() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ConfigPropertyFileProfileTest.jar")).addClasses(new Class[]{ConfigPropertyFileProfileTest.class, ProfilePropertyBean.class})).addAsManifestResource((Asset)new StringAsset("mp.config.profile=dev\nvehicle.name=car\nvehicle.colour=red"), "microprofile-config.properties")).addAsManifestResource((Asset)new StringAsset("vehicle.name=bike\nvehicle.owner=Bob"), "microprofile-config-dev.properties")).addAsManifestResource((Asset)new StringAsset("vehicle.name=bike\nvehicle.age=5"), "microprofile-config-prod.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ConfigPropertyFileProfileTest.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testConfigProfileWithDev() {
        ProfilePropertyBean bean = (ProfilePropertyBean)CDI.current().select(ProfilePropertyBean.class, new Annotation[0]).get();
        MatcherAssert.assertThat((Object)bean.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bike")));
        MatcherAssert.assertThat((Object)bean.getColour(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"red")));
        MatcherAssert.assertThat((Object)bean.getOwner(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Bob")));
        Assert.assertEquals((long)bean.getVehicleAge(), (long)10L);
        MatcherAssert.assertThat((Object)ConfigProvider.getConfig().getValue("vehicle.name", String.class), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bike")));
        MatcherAssert.assertThat((Object)ConfigProvider.getConfig().getValue("vehicle.colour", String.class), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"red")));
        MatcherAssert.assertThat((Object)ConfigProvider.getConfig().getValue("vehicle.owner", String.class), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Bob")));
        Assert.assertFalse((boolean)ConfigProvider.getConfig().getOptionalValue("vehicle.age", Integer.class).isPresent());
    }

    @Dependent
    public static class ProfilePropertyBean {
        @Inject
        @ConfigProperty(name="vehicle.name")
        private String name;
        @Inject
        @ConfigProperty(name="vehicle.age", defaultValue="10")
        private int age;
        @Inject
        @ConfigProperty(name="vehicle.colour", defaultValue="black")
        private String colour;
        @Inject
        @ConfigProperty(name="vehicle.owner", defaultValue="Jane")
        private String owner;

        public String getName() {
            return this.name;
        }

        public int getVehicleAge() {
            return this.age;
        }

        public String getColour() {
            return this.colour;
        }

        public String getOwner() {
            return this.owner;
        }
    }
}

