/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.trs.server.service;

import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.lyo.core.trs.Base;
import org.eclipse.lyo.core.trs.ChangeLog;
import org.eclipse.lyo.core.trs.Page;
import org.eclipse.lyo.core.trs.TrackedResourceSet;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcService;
import org.eclipse.lyo.oslc4j.core.model.Error;
import org.eclipse.lyo.oslc4j.trs.server.PagedTrs;
import org.eclipse.lyo.oslc4j.trs.server.TRSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/trs")
@OslcService(value="http://open-services.net/ns/core/trs#")
public class TrackedResourceSetService {
    private static final Logger log = LoggerFactory.getLogger(TrackedResourceSetService.class);
    public static final String BASE_PATH = "base";
    public static final String CHANGELOG_PATH = "changeLog";
    public static final String RESOURCE_PATH = "/trs";
    private PagedTrs changeHistories;
    private String base;

    public TrackedResourceSetService() {
    }

    @Inject
    public TrackedResourceSetService(PagedTrs _changeHistories) {
        this.changeHistories = _changeHistories;
    }

    public TrackedResourceSetService(PagedTrs _changeHistories, String base) {
        this.changeHistories = _changeHistories;
        this.base = base;
    }

    @GET
    @Produces(value={"text/turtle", "application/rdf+xml", "application/xml", "application/json"})
    public TrackedResourceSet getTrackedResourceSet() throws URISyntaxException {
        TrackedResourceSet result = new TrackedResourceSet();
        result.setAbout(this.uriBuilder().build(new Object[0]));
        result.setBase(this.uriBuilder().path(BASE_PATH).build(new Object[0]));
        if (this.getPagedTrs().changelogPageCount() == 0) {
            result.setChangeLog(new ChangeLog());
        } else {
            result.setChangeLog(this.getPagedTrs().getChangeLogLast());
        }
        return result;
    }

    @GET
    @Path(value="base")
    public Response getBase() {
        URI newURI = this.uriBuilder().path(BASE_PATH).path("1").build(new Object[0]);
        return Response.seeOther((URI)newURI).build();
    }

    @GET
    @Path(value="base/{page}")
    @Produces(value={"text/turtle", "application/rdf+xml", "application/xml", "application/json"})
    public Response getBasePage(@PathParam(value="page") int pageNo) {
        Base base = this.getPagedTrs().getBaseResource(pageNo);
        if (base == null) {
            Error entity = new Error();
            entity.setMessage("Wrong TRS Base page URI");
            entity.setStatusCode(String.valueOf(Response.Status.NOT_FOUND.getStatusCode()));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)entity).build();
        }
        Page nextPage = base.getNextPage();
        if (nextPage == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        log.debug("TRS Base page contains {} members", (Object)base.getMembers().size());
        return Response.ok((Object)base).header("Link", (Object)TRSUtil.linkHeaderValue(base)).build();
    }

    protected PagedTrs getPagedTrs() {
        return this.changeHistories;
    }

    @GET
    @Path(value="changeLog")
    public Response getChangeLog() {
        URI newURI = this.uriBuilder().path(CHANGELOG_PATH).path("1").build(new Object[0]);
        return Response.seeOther((URI)newURI).build();
    }

    @GET
    @Path(value="changeLog/{page}")
    @Produces(value={"text/turtle", "application/rdf+xml", "application/xml", "application/json"})
    public Response getChangeLogPage(@PathParam(value="page") int page) {
        log.trace("TRS Change Log page '{}' requested", (Object)page);
        ChangeLog changeLog = this.getPagedTrs().getChangeLog(page);
        if (changeLog == null) {
            Error entity = new Error();
            entity.setMessage("Wrong TRS Change Log page URI");
            entity.setStatusCode(String.valueOf(Response.Status.NOT_FOUND.getStatusCode()));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)entity).build();
        }
        log.debug("TRS Change Log page contains {} members", (Object)changeLog.getChange().size());
        return Response.ok((Object)changeLog).build();
    }

    private UriBuilder uriBuilder() {
        if (Strings.isNullOrEmpty((String)this.base)) {
            return UriBuilder.fromUri((String)OSLC4JUtils.getServletURI()).path(RESOURCE_PATH);
        }
        return UriBuilder.fromUri((String)this.base);
    }
}

