/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.trs.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.lyo.core.trs.Base;
import org.eclipse.lyo.core.trs.ChangeEvent;
import org.eclipse.lyo.core.trs.ChangeLog;
import org.eclipse.lyo.core.trs.Creation;
import org.eclipse.lyo.core.trs.Deletion;
import org.eclipse.lyo.core.trs.Modification;
import org.eclipse.lyo.core.trs.Page;
import org.eclipse.lyo.oslc4j.core.model.IResource;
import org.eclipse.lyo.oslc4j.trs.server.HistoryData;
import org.eclipse.lyo.oslc4j.trs.server.PagedTrs;
import org.eclipse.lyo.oslc4j.trs.server.TRSUtil;
import org.eclipse.lyo.oslc4j.trs.server.TrsEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InmemPagedTrs
implements PagedTrs,
TrsEventHandler {
    private static final Logger log = LoggerFactory.getLogger(InmemPagedTrs.class);
    private final int changelogPageLimit;
    private final URI uriBase;
    private final AtomicLong trsOrderId = new AtomicLong();
    private final int basePageLimit;
    private final String baseRelativePath;
    private final String changeLogRelativePath;
    private final List<Base> baseResources = new ArrayList<Base>();
    private final List<ChangeLog> changelogResources = new ArrayList<ChangeLog>();

    public InmemPagedTrs(int basePageLimit, int changelogPageLimit, URI uriBase, String baseRelativePath, String changeLogRelativePath, Collection<URI> baseResourceUris) {
        this.basePageLimit = basePageLimit;
        this.changelogPageLimit = changelogPageLimit;
        this.uriBase = uriBase;
        this.baseRelativePath = baseRelativePath;
        this.changeLogRelativePath = changeLogRelativePath;
        this.initBase(baseResourceUris);
    }

    public InmemPagedTrs(int basePageLimit, int changelogPageLimit, URI uriBase, Collection<URI> baseResourceUris) {
        this.basePageLimit = basePageLimit;
        this.changelogPageLimit = changelogPageLimit;
        this.uriBase = uriBase;
        this.baseRelativePath = "base";
        this.changeLogRelativePath = "changelog";
        this.initBase(baseResourceUris);
    }

    @Override
    public Base getBaseResource(Integer pageId) {
        int listIdx = this.pageIdToListIdx(pageId);
        if (listIdx < 0 || listIdx >= this.baseResources.size()) {
            throw new IllegalArgumentException("There is no such Base page");
        }
        return this.baseResources.get(listIdx);
    }

    private int pageIdToListIdx(Integer pageId) {
        return pageId - 1;
    }

    @Override
    public int basePageCount() {
        return this.baseResources.size();
    }

    @Override
    public ChangeLog getChangeLog(Integer pageId) {
        int listIdx = this.pageIdToListIdx(pageId);
        if (listIdx < 0 || listIdx >= this.changelogResources.size()) {
            throw new IllegalArgumentException("There is no such ChangeLog page");
        }
        return this.changelogResources.get(listIdx);
    }

    @Override
    public ChangeLog getChangeLogLast() {
        return this.getChangeLog(this.changelogPageCount());
    }

    @Override
    public int changelogPageCount() {
        return this.changelogResources.size();
    }

    @Override
    public void onCreated(IResource resource) {
        HistoryData instance = HistoryData.getInstance(new Date(), resource.getAbout(), "Created");
        this.onHistoryData(instance);
    }

    @Override
    public void onModified(IResource resource) {
        HistoryData instance = HistoryData.getInstance(new Date(), resource.getAbout(), "Modified");
        this.onHistoryData(instance);
    }

    @Override
    public void onDeleted(URI resourceUri) {
        HistoryData instance = HistoryData.getInstance(new Date(), resourceUri, "Deleted");
        this.onHistoryData(instance);
    }

    public void onHistoryData(HistoryData event) {
        ChangeLog changeLog = this.findOrCreateChangelogPage();
        ChangeEvent changeEvent = this.createChangeEvent(event);
        changeLog.getChange().add(changeEvent);
    }

    private ChangeEvent createChangeEvent(long changeOrder, URI trackedResourceUri, URI eventUri, String histDataType) {
        Creation ce;
        if (changeOrder >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Switch ChangeEvents to use longs");
        }
        if (Objects.equals(histDataType, "Created")) {
            ce = new Creation(eventUri, trackedResourceUri, (long)((int)changeOrder));
        } else if (Objects.equals(histDataType, "Modified")) {
            ce = new Modification(eventUri, trackedResourceUri, (long)((int)changeOrder));
        } else if (Objects.equals(histDataType, "Deleted")) {
            ce = new Deletion(eventUri, trackedResourceUri, (long)((int)changeOrder));
        } else {
            log.error("Change Event {} has unknown kind: {}", (Object)trackedResourceUri, (Object)histDataType);
            throw new IllegalArgumentException();
        }
        return ce;
    }

    private ChangeEvent createChangeEvent(HistoryData event) {
        long order = this.nextCutoff();
        URI ceUri = this.createUuidUrn();
        if (order >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Switch ChangeEvents to use longs");
        }
        return this.createChangeEvent((int)order, event.getUri(), ceUri, event.getType());
    }

    private void initBase(Collection<URI> baseResourceUris) {
        Base base = this.findOrCreateBase();
        int remainingResources = this.calcRemainingResources(base);
        for (URI resourceUris : baseResourceUris) {
            if (remainingResources < 1) {
                base = this.findOrCreateBase();
                remainingResources = this.calcRemainingResources(base);
            }
            base.getMembers().add(resourceUris);
            --remainingResources;
        }
    }

    private Base findOrCreateBase() {
        Base page;
        if (this.baseResources.isEmpty()) {
            page = this.createBase();
        } else {
            Base lastBase = this.getLastBaseResource();
            if (this.isBaseFull(lastBase)) {
                page = this.createBase();
                lastBase.getNextPage().setNextPage(page.getNextPage().getAbout());
            } else {
                page = lastBase;
            }
        }
        return page;
    }

    private Base createBase() {
        Base base = new Base();
        base.setAbout(this.createBaseUri());
        base.setNextPage(this.createBasePage(base, this.nextBasePageId()));
        base.setCutoffEvent(URI.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil"));
        log.debug("Adding a new Base resource");
        this.baseResources.add(base);
        return base;
    }

    private Page createBasePage(Base base, int pageId) {
        Page basePage = new Page();
        basePage.setAbout(this.createBasePageUri(pageId));
        basePage.setNextPage(URI.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil"));
        basePage.setPageOf(base);
        return basePage;
    }

    private ChangeLog findOrCreateChangelogPage() {
        ChangeLog page;
        if (this.changelogResources.isEmpty()) {
            page = this.createChangelogPage(TRSUtil.NIL_URI, null);
        } else {
            ChangeLog lastPage = this.getLastChangelogPage();
            if (this.isChangelogPageFull(lastPage)) {
                lastPage.setAbout(this.createChangelogUri());
                page = this.createChangelogPage(lastPage.getAbout(), null);
            } else {
                page = lastPage;
            }
        }
        return page;
    }

    private ChangeLog createChangelogPage(URI previous, URI current) {
        ChangeLog changelog = new ChangeLog();
        changelog.setAbout(current);
        changelog.setPrevious(previous);
        this.changelogResources.add(changelog);
        return changelog;
    }

    private int calcRemainingResources(Base base) {
        int remaining = this.basePageLimit - base.getMembers().size();
        if (remaining < 0) {
            log.warn("Base contains more resources than it should!");
        }
        return Math.max(remaining, 0);
    }

    private boolean isBaseFull(Base base) {
        return this.calcRemainingResources(base) == 0;
    }

    private boolean isChangelogPageFull(ChangeLog changeLog) {
        return changeLog.getChange().size() >= this.changelogPageLimit;
    }

    private ChangeLog getLastChangelogPage() {
        return this.changelogResources.get(this.changelogResources.size() - 1);
    }

    private int nextBasePageId() {
        return this.basePageIdFor(this.baseResources.size());
    }

    private int basePageIdFor(int listIdx) {
        return listIdx + 1;
    }

    private Base getLastBaseResource() {
        return this.baseResources.get(this.baseResources.size() - 1);
    }

    private URI createBaseUri() {
        URI uri = this.getUriBuilder().path(this.baseRelativePath).build(new Object[0]);
        return uri;
    }

    private URI createBasePageUri(int pageId) {
        URI uri = this.getUriBuilder().path(this.baseRelativePath).path(String.valueOf(pageId)).build(new Object[0]);
        return uri;
    }

    private URI createChangelogUri() {
        int nextPageId = this.changelogResources.size();
        URI uri = this.getUriBuilder().path(this.changeLogRelativePath).path(String.valueOf(nextPageId)).build(new Object[0]);
        return uri;
    }

    private long nextCutoff() {
        long next = this.trsOrderId.incrementAndGet();
        return next;
    }

    private UriBuilder getUriBuilder() {
        return UriBuilder.fromUri((URI)this.uriBase);
    }

    private URI createUuidUrn() {
        return URI.create(String.format("urn:uuid:%s", UUID.randomUUID().toString()));
    }
}

