/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.trs.client.util;

import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.eclipse.lyo.core.trs.Base;
import org.eclipse.lyo.core.trs.ChangeLog;
import org.eclipse.lyo.core.trs.Creation;
import org.eclipse.lyo.core.trs.Deletion;
import org.eclipse.lyo.core.trs.Modification;
import org.eclipse.lyo.core.trs.Page;
import org.eclipse.lyo.core.trs.TrackedResourceSet;
import org.eclipse.lyo.oslc4j.core.exception.LyoModelException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;
import org.eclipse.lyo.trs.client.exceptions.TrsEndpointConfigException;
import org.eclipse.lyo.trs.client.exceptions.TrsEndpointErrorException;
import org.eclipse.lyo.trs.client.util.ProviderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientUtil {
    private static final Logger log = LoggerFactory.getLogger(ClientUtil.class);

    ClientUtil() {
    }

    static ChangeLog extractChangeLogFromRdfModel(Model rdFModel) throws LyoModelException {
        log.debug("started extracting change log from rdf model");
        Object[] changeLogs = (ChangeLog[])JenaModelHelper.unmarshal((Model)rdFModel, ChangeLog.class);
        Object[] creations = (Creation[])JenaModelHelper.unmarshal((Model)rdFModel, Creation.class);
        Object[] modifications = (Modification[])JenaModelHelper.unmarshal((Model)rdFModel, Modification.class);
        Object[] deletions = (Deletion[])JenaModelHelper.unmarshal((Model)rdFModel, Deletion.class);
        if (ProviderUtil.isNotEmptySingletonArray(changeLogs) && changeLogs[0] != null) {
            Object changeLog = changeLogs[0];
            changeLog.getChange().clear();
            if (ProviderUtil.isNotEmpty(modifications)) {
                changeLog.getChange().addAll(Arrays.asList(modifications));
            }
            if (ProviderUtil.isNotEmpty(creations)) {
                changeLog.getChange().addAll(Arrays.asList(creations));
            }
            if (ProviderUtil.isNotEmpty(deletions)) {
                changeLog.getChange().addAll(Arrays.asList(deletions));
            }
            log.debug("finished extracting change log set from rdf model");
            return changeLog;
        }
        log.warn("the change log was missing; returning an empty one");
        return new ChangeLog();
    }

    static Base extractBaseFromRdfModel(Model rdFModel) throws LyoModelException {
        log.debug("started extracting base from rdf model");
        Base baseObj = null;
        Object[] nextPageArray = JenaModelHelper.unmarshal((Model)rdFModel, Page.class);
        Object[] basesArray = JenaModelHelper.unmarshal((Model)rdFModel, Base.class);
        if (ProviderUtil.isNotEmptySingletonArray(basesArray) && basesArray[0] instanceof Base) {
            baseObj = (Base)basesArray[0];
        }
        if (baseObj == null) {
            log.error("Base page object is null");
            return null;
        }
        if (ProviderUtil.isNotEmptySingletonArray(nextPageArray) && nextPageArray[0] instanceof Page) {
            Page nextPage = (Page)nextPageArray[0];
            baseObj.setNextPage(nextPage);
        } else {
            log.debug("Base page {} is the last one", (Object)baseObj.getAbout());
        }
        log.debug("finished extracting base from rdf model");
        return baseObj;
    }

    static TrackedResourceSet extractTrsFromRdfModel(Model rdFModel) throws LyoModelException {
        log.debug("started extracting tracked resource set from rdf model");
        Object[] trackedResourceSets = (TrackedResourceSet[])JenaModelHelper.unmarshal((Model)rdFModel, TrackedResourceSet.class);
        if (ProviderUtil.isNotEmptySingletonArray(trackedResourceSets) && trackedResourceSets[0] != null) {
            Object trs = trackedResourceSets[0];
            ChangeLog trsChangeLog = ClientUtil.extractChangeLogFromRdfModel(rdFModel);
            try {
                trs.setChangeLog(trsChangeLog);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Should never happen");
            }
            log.debug("finished extracting tracked resource set from rdf model");
            return trs;
        }
        throw new IllegalArgumentException("TRS resource cannot be extracted from the Model");
    }

    static Object extractResourceFromResponse(Response response, Class<?> objClass) throws TrsEndpointConfigException, TrsEndpointErrorException, LyoModelException {
        Response.StatusType responseInfo = response.getStatusInfo();
        Response.Status.Family httpCodeType = responseInfo.getFamily();
        if (httpCodeType.equals((Object)Response.Status.Family.CLIENT_ERROR)) {
            throw new TrsEndpointConfigException("Error " + responseInfo.getReasonPhrase());
        }
        if (httpCodeType.equals((Object)Response.Status.Family.SERVER_ERROR)) {
            throw new TrsEndpointErrorException("Error " + responseInfo.getReasonPhrase());
        }
        if (AbstractResource.class.isAssignableFrom(objClass)) {
            Object objToRet = response.readEntity(objClass);
            log.trace("Finished consuming content from server response");
            return objToRet;
        }
        if (Model.class.isAssignableFrom(objClass)) {
            return ClientUtil.extractModelFromResponse(response);
        }
        throw new IllegalStateException("The resources could not be fetched");
    }

    private static Model extractModelFromResponse(Response clientResponse) throws LyoModelException {
        if (clientResponse == null) {
            log.warn("The server response is null. Returning null");
            return null;
        }
        String responseAsString = (String)clientResponse.readEntity(String.class);
        log.trace("Response:\n{}\n", (Object)responseAsString);
        if (responseAsString == null) {
            log.warn("The server response is null. Returning null");
            return null;
        }
        log.trace("Creating Jena model from server response string");
        Model rdFModel = ModelFactory.createDefaultModel();
        try (ByteArrayInputStream is = new ByteArrayInputStream(responseAsString.getBytes(StandardCharsets.UTF_8));){
            rdFModel.read((InputStream)is, null);
        }
        catch (IOException e) {
            throw new LyoModelException((Throwable)e);
        }
        log.trace("OK! Created Jena model from server response string");
        if (!rdFModel.isEmpty() && log.isDebugEnabled()) {
            log.debug("Created model contains {} statements", (Object)rdFModel.size());
        }
        return rdFModel;
    }
}

