/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.trs.client.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TRSScheduledExecutorService
extends ScheduledThreadPoolExecutor {
    static final Logger logger = LoggerFactory.getLogger(TRSScheduledExecutorService.class);

    public TRSScheduledExecutorService(int corePoolSize) {
        super(corePoolSize);
    }

    public TRSScheduledExecutorService(int corePoolSize, ThreadFactory tf) {
        super(corePoolSize, tf);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                t = ce;
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            logger.error("Non-empty throwable after execution", t);
        }
    }
}

