/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.trs.client.handlers.sparql;

import org.apache.jena.rdf.model.Model;
import org.eclipse.lyo.core.trs.ChangeEvent;
import org.eclipse.lyo.core.trs.Deletion;
import org.eclipse.lyo.trs.client.handlers.IProviderEventHandler;
import org.eclipse.lyo.trs.client.model.BaseMember;
import org.eclipse.lyo.trs.client.model.ChangeEventMessageTR;
import org.eclipse.lyo.trs.client.util.SparqlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlDirectHandler
implements IProviderEventHandler {
    private static final Logger log = LoggerFactory.getLogger(SparqlDirectHandler.class);
    private final String sparqlUpdateService;

    public SparqlDirectHandler(String sparqlUpdateService) {
        this.sparqlUpdateService = sparqlUpdateService;
    }

    @Override
    public void finishCycle() {
    }

    @Override
    public void handleBaseMember(BaseMember baseMember) {
        SparqlUtil.createGraph(baseMember.getUri().toString(), this.sparqlUpdateService);
        SparqlUtil.addTriplesToNamedGraph(baseMember.getModel(), baseMember.getUri().toString(), this.sparqlUpdateService);
    }

    @Override
    public void handleChangeEvent(ChangeEventMessageTR eventMessageTR) {
        ChangeEvent changeEvent = eventMessageTR.getChangeEvent();
        Model trsResourceModel = eventMessageTR.getTrackedResourceModel();
        if (changeEvent instanceof Deletion) {
            SparqlUtil.processChangeEvent(changeEvent, null, this.sparqlUpdateService);
        } else if (trsResourceModel != null) {
            SparqlUtil.processChangeEvent(changeEvent, trsResourceModel, this.sparqlUpdateService);
        }
    }

    @Override
    public void rebase() {
    }
}

