/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.trs.client.config;

import com.google.common.base.Strings;
import java.util.concurrent.ScheduledExecutorService;
import javax.ws.rs.client.ClientBuilder;
import org.eclipse.lyo.client.OslcClient;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

public class TrsConsumerConfiguration {
    private final String sparqlQueryUrl;
    private final String sparqlUpdateUrl;
    private final String sparqlUsername;
    private final String sparqlPassword;
    private final ScheduledExecutorService scheduler;
    private final String basicUsername;
    private final String basicPassword;
    private OslcClient httpClient;

    public TrsConsumerConfiguration(String sparqlQueryUrl, String sparqlUpdateUrl, String sparqlUsername, String sparqlPassword, ScheduledExecutorService scheduler, String basicUsername, String basicPassword) {
        this.sparqlQueryUrl = sparqlQueryUrl;
        this.sparqlUpdateUrl = sparqlUpdateUrl;
        this.sparqlUsername = sparqlUsername;
        this.sparqlPassword = sparqlPassword;
        this.scheduler = scheduler;
        this.basicUsername = basicUsername;
        this.basicPassword = basicPassword;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public String getSparqlQueryUrl() {
        return this.sparqlQueryUrl;
    }

    public String getSparqlUpdateUrl() {
        return this.sparqlUpdateUrl;
    }

    public String getSparqlUsername() {
        return this.sparqlUsername;
    }

    public String getSparqlPassword() {
        return this.sparqlPassword;
    }

    public OslcClient getHttpClient() {
        if (this.httpClient == null) {
            ClientBuilder builder = ClientBuilder.newBuilder();
            if (!Strings.isNullOrEmpty((String)this.basicUsername)) {
                builder.register((Object)HttpAuthenticationFeature.basic((String)this.basicUsername, (String)this.basicPassword));
            }
            this.httpClient = new OslcClient(builder);
        }
        return this.httpClient;
    }
}

