/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.trs.client.mqtt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.eclipse.lyo.core.trs.ChangeEvent;
import org.eclipse.lyo.core.trs.Creation;
import org.eclipse.lyo.core.trs.Deletion;
import org.eclipse.lyo.core.trs.Modification;
import org.eclipse.lyo.oslc4j.core.exception.LyoModelException;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;
import org.eclipse.lyo.trs.client.exceptions.RepresentationRetrievalException;
import org.eclipse.lyo.trs.client.handlers.IPushProviderHandler;
import org.eclipse.lyo.trs.client.model.ChangeEventMessageTR;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/eclipse/lyo/trs/client/mqtt/MqttTrsEventListener;", "Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;", "providerHandler", "Lorg/eclipse/lyo/trs/client/handlers/IPushProviderHandler;", "lang", "Lorg/apache/jena/riot/Lang;", "(Lorg/eclipse/lyo/trs/client/handlers/IPushProviderHandler;Lorg/apache/jena/riot/Lang;)V", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "messageArrived", "", "topic", "", "mqttMessage", "Lorg/eclipse/paho/client/mqttv3/MqttMessage;", "rejectLegacyPayloads", "payload", "removeResource", "subject", "Ljava/net/URI;", "model", "Lorg/apache/jena/rdf/model/Model;", "unmarshalChangeEvent", "Lorg/eclipse/lyo/trs/client/model/ChangeEventMessageTR;", "Companion", "client-source-mqtt"})
public final class MqttTrsEventListener
implements IMqttMessageListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IPushProviderHandler providerHandler;
    @NotNull
    private final Lang lang;
    private final Logger log;
    private final ScheduledExecutorService executorService;

    public MqttTrsEventListener(@NotNull IPushProviderHandler providerHandler, @NotNull Lang lang) {
        Intrinsics.checkNotNullParameter((Object)providerHandler, (String)"providerHandler");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        this.providerHandler = providerHandler;
        this.lang = lang;
        this.log = LoggerFactory.getLogger(MqttTrsEventListener.class);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void messageArrived(@NotNull String topic, @NotNull MqttMessage mqttMessage) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)mqttMessage, (String)"mqttMessage");
        byte[] byArray = mqttMessage.getPayload();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"mqttMessage.payload");
        byte[] byArray2 = byArray;
        String payload = new String(byArray2, Charsets.UTF_8);
        this.log.trace("Message payload: " + payload);
        this.rejectLegacyPayloads(payload);
        this.executorService.submit(() -> MqttTrsEventListener.messageArrived$lambda-0(this, payload, topic));
    }

    private final void rejectLegacyPayloads(String payload) {
        if (StringsKt.equals((String)payload, (String)"NEW", (boolean)true)) {
            this.log.warn("Plain 'NEW' ping message received");
            throw new IllegalArgumentException("'NEW' payload is no longer supported; send an RDF graph");
        }
        if (StringsKt.startsWith$default((String)payload, (String)"<ModelCom", (boolean)false, (int)2, null)) {
            throw new IllegalArgumentException("Malformed RDF from the serialised Jena Model; use RDFDataMgr");
        }
    }

    private final ChangeEventMessageTR unmarshalChangeEvent(String payload) {
        ChangeEvent changeEvent = null;
        Model payloadModel = ModelFactory.createDefaultModel();
        String string = payload;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byArray);
        RDFDataMgr.read((Model)payloadModel, (InputStream)inputStream, (Lang)this.lang);
        try {
            Object object = JenaModelHelper.unmarshalSingle((Model)payloadModel, Modification.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"unmarshalSingle(payloadM\u2026Modification::class.java)");
            changeEvent = (ChangeEvent)object;
            this.log.debug("Encountered a Modification event");
        }
        catch (IllegalArgumentException e) {
            try {
                Object object = JenaModelHelper.unmarshalSingle((Model)payloadModel, Creation.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"unmarshalSingle(payloadM\u2026el, Creation::class.java)");
                changeEvent = (ChangeEvent)object;
                this.log.debug("Encountered a Creation event");
            }
            catch (IllegalArgumentException e1) {
                try {
                    Object object = JenaModelHelper.unmarshalSingle((Model)payloadModel, Deletion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"unmarshalSingle(payloadM\u2026    Deletion::class.java)");
                    changeEvent = (ChangeEvent)object;
                    this.log.debug("Encountered a Deletion event");
                }
                catch (IllegalArgumentException e2) {
                    this.log.error("Can't unmarshal the payload", (Throwable)e2);
                    throw new RepresentationRetrievalException("Payload does not contain a ChangeEvent", (Throwable)e2);
                }
            }
        }
        Model trModel = ModelFactory.createDefaultModel();
        trModel.add(payloadModel);
        URI uRI = changeEvent.getAbout();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"changeEvent.about");
        Intrinsics.checkNotNullExpressionValue((Object)trModel, (String)"trModel");
        this.removeResource(uRI, trModel);
        return new ChangeEventMessageTR(changeEvent, trModel);
    }

    private final void removeResource(URI subject, Model model) {
        model.removeAll(MqttTrsEventListener.Companion.r(subject), null, null);
    }

    private static final void messageArrived$lambda-0(MqttTrsEventListener this$0, String $payload, String $topic) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$payload, (String)"$payload");
        Intrinsics.checkNotNullParameter((Object)$topic, (String)"$topic");
        this$0.log.info("Processing Change Event");
        try {
            ChangeEventMessageTR eventMessage = this$0.unmarshalChangeEvent($payload);
            this$0.providerHandler.handlePush(eventMessage, $topic);
        }
        catch (LyoModelException e) {
            this$0.log.warn("Error processing Change Event", (Throwable)e);
        }
        catch (Exception e) {
            this$0.log.error("Unexpected exception", (Throwable)e);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/eclipse/lyo/trs/client/mqtt/MqttTrsEventListener$Companion;", "", "()V", "r", "Lorg/apache/jena/rdf/model/Resource;", "resourceUri", "Ljava/net/URI;", "client-source-mqtt"})
    public static final class Companion {
        private Companion() {
        }

        private final Resource r(URI resourceUri) {
            Resource resource = ResourceFactory.createResource((String)resourceUri.toString());
            Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"createResource(resourceUri.toString())");
            return resource;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

