/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.shacl;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValue;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRdfCollectionType;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://www.w3.org/ns/shacl#")
@OslcName(value="Property")
@OslcResourceShape(title="SHACL Property Resource Shape", describes={"http://www.w3.org/ns/shacl#Property"})
public class Property
extends AbstractResource {
    private URI path;
    private URI classType;
    private ValueType dataType;
    private URI nodeKind;
    private BigInteger minCount;
    private BigInteger maxCount;
    private BigInteger minExclusive;
    private BigInteger maxExclusive;
    private BigInteger minInclusive;
    private BigInteger maxInclusive;
    private BigInteger minLength;
    private BigInteger maxLength;
    private String pattern;
    private String[] languageIn;
    private Boolean uniqueLang;
    private String[] in;
    private String name;
    private String description;
    private BigInteger order;
    private URI group;
    private URI severity;
    private String message;
    private Boolean deactivated;
    private URI node;
    private URI equals;
    private URI disjoint;
    private URI lessThan;
    private URI lessThanOrEquals;
    private URI hasValue;

    public Property() {
    }

    public Property(URI path, ValueType dataType, BigInteger minCount, BigInteger maxCount) {
        this();
        this.path = path;
        this.dataType = dataType;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public String toString() {
        return "Property [path=" + this.path + ", classType=" + this.classType + ", dataType=" + this.dataType + ", nodeKind=" + this.nodeKind + ", minCount=" + this.minCount + ", maxCount=" + this.maxCount + ", minExclusive=" + this.minExclusive + ", maxExclusive=" + this.maxExclusive + ", minInclusive=" + this.minInclusive + ", maxInclusive=" + this.maxInclusive + ", minLength=" + this.minLength + ", maxLength=" + this.maxLength + ", pattern=" + this.pattern + ", languageIn=" + Arrays.toString(this.languageIn) + ", uniqueLang=" + this.uniqueLang + ", in=" + Arrays.toString(this.in) + ", name=" + this.name + ", description=" + this.description + ", severity=" + this.severity + ", message=" + this.message + "]";
    }

    @OslcDescription(value="Use cases of this feature include shape reuse and debugging.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#deactivated")
    @OslcValueType(value=ValueType.Boolean)
    @OslcTitle(value="Deactivated")
    public Boolean isDeactivated() {
        return this.deactivated;
    }

    public void addIn(Object newIn) {
        this.appendValue(this.in, newIn);
    }

    @OslcDescription(value="path of a property")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#path")
    @OslcReadOnly
    @OslcName(value="path")
    public URI getPath() {
        return this.path;
    }

    public void setPath(URI path) {
        this.path = path;
    }

    @OslcDescription(value="Sets the order of a property")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#order")
    @OslcReadOnly
    @OslcName(value="order")
    public BigInteger getOrder() {
        return this.order;
    }

    public void setOrder(BigInteger order) {
        this.order = order;
    }

    @OslcDescription(value="Indicate that the shape belongs to a group of related property shapes")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#group")
    @OslcReadOnly
    @OslcName(value="group")
    public URI getGroup() {
        return this.group;
    }

    public void setGroup(URI group) {
        this.group = group;
    }

    @OslcAllowedValue(value={"http://www.w3.org/2001/XMLSchema#boolean", "http://www.w3.org/2001/XMLSchema#dateTime", "http://www.w3.org/2001/XMLSchema#decimal", "http://www.w3.org/2001/XMLSchema#double", "http://www.w3.org/2001/XMLSchema#float", "http://www.w3.org/2001/XMLSchema#integer", "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral"})
    @OslcDescription(value="See list of allowed values for sh:datatype")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#datatype")
    @OslcReadOnly
    @OslcName(value="datatype")
    @OslcTitle(value="Data Type")
    public URI getDataType() {
        if (this.dataType != null) {
            try {
                return new URI(this.dataType.toString());
            }
            catch (URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    public void setDataType(URI dataType) {
        this.dataType = dataType != null ? ValueType.fromString((String)dataType.toString()) : null;
    }

    @OslcDescription(value="Specifies the description")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#description")
    @OslcTitle(value="Description")
    @OslcValueType(value=ValueType.String)
    @OslcName(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @OslcDescription(value="Specifies the message to be shown in resultMessage of Validation report")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#message")
    @OslcTitle(value="Message")
    @OslcValueType(value=ValueType.String)
    @OslcName(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @OslcDescription(value="Specifies the name")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#name")
    @OslcTitle(value="Name")
    @OslcValueType(value=ValueType.String)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @OslcDescription(value="Specifies the min count")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#minCount")
    @OslcReadOnly
    @OslcTitle(value="Min Count")
    @OslcValueType(value=ValueType.Integer)
    public BigInteger getMinCount() {
        return this.minCount;
    }

    public void setMinCount(BigInteger minCount) {
        this.minCount = minCount;
    }

    @OslcDescription(value="Specifies the max count")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#maxCount")
    @OslcReadOnly
    @OslcTitle(value="Max Count")
    @OslcValueType(value=ValueType.Integer)
    public BigInteger getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(BigInteger maxCount) {
        this.maxCount = maxCount;
    }

    @OslcDescription(value="Specifies the range: Min Exclusive")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#minExclusive")
    @OslcValueType(value=ValueType.Integer)
    @OslcTitle(value="Range Min Exclusive")
    public BigInteger getMinExclusive() {
        return this.minExclusive;
    }

    public void setMinExclusive(BigInteger minExclusive) {
        this.minExclusive = minExclusive;
    }

    @OslcDescription(value="Specifies the range: Max Exclusive")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#maxExclusive")
    @OslcValueType(value=ValueType.Integer)
    @OslcTitle(value="Range Max Exclusive")
    public BigInteger getMaxExclusive() {
        return this.maxExclusive;
    }

    public void setMaxExclusive(BigInteger maxExclusive) {
        this.maxExclusive = maxExclusive;
    }

    @OslcDescription(value="Specifies the range: Min Inclusive")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#minInclusive")
    @OslcValueType(value=ValueType.Integer)
    @OslcTitle(value="Range Min Inclusive")
    public BigInteger getMinInclusive() {
        return this.minInclusive;
    }

    public void setMinInclusive(BigInteger minInclusive) {
        this.minInclusive = minInclusive;
    }

    @OslcDescription(value="Specifies the range: Max Inclusive")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#maxInclusive")
    @OslcValueType(value=ValueType.Integer)
    @OslcTitle(value="Range Max Inclusive")
    public BigInteger getMaxInclusive() {
        return this.maxInclusive;
    }

    public void setMaxInclusive(BigInteger maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    @OslcDescription(value="Specifies the minimum string length of each value node that satisfies the condition.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#minLength")
    @OslcValueType(value=ValueType.Integer)
    @OslcTitle(value="Minimum Length")
    public BigInteger getMinLength() {
        return this.minLength;
    }

    public void setMinLength(BigInteger minLength) {
        this.minLength = minLength;
    }

    @OslcDescription(value="Specifies the maximum string length of each value node that satisfies the condition.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#maxLength")
    @OslcValueType(value=ValueType.Integer)
    @OslcTitle(value="Maximum Length")
    public BigInteger getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(BigInteger maxLength) {
        this.maxLength = maxLength;
    }

    @OslcDescription(value="Specifies a regular expression that each value node matches to satisfy the condition.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#pattern")
    @OslcValueType(value=ValueType.String)
    @OslcTitle(value="Pattern")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @OslcDescription(value="Specifies the allowed language tags for each value node limited by a given list of language tags.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#languageIn")
    @OslcValueType(value=ValueType.String)
    @OslcTitle(value="LanguageIn")
    public String[] getLanguageIn() {
        return this.languageIn;
    }

    public void setLanguageIn(String[] languageIn) {
        this.languageIn = languageIn;
    }

    @OslcDescription(value="Specifies that no pair of value nodes may use the same language tag if set true.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#uniqueLang")
    @OslcValueType(value=ValueType.Boolean)
    @OslcTitle(value="UniqueLang")
    public Boolean getUniqueLang() {
        return this.uniqueLang;
    }

    public void setUniqueLang(Boolean uniqueLang) {
        this.uniqueLang = uniqueLang;
    }

    @OslcDescription(value="Specifies the Class of a node")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#class")
    @OslcTitle(value="Class")
    @OslcName(value="class")
    public URI getClassType() {
        return this.classType;
    }

    public void setClassType(URI classType) {
        this.classType = classType;
    }

    @OslcDescription(value="Specifies the node kind. Values can be: sh:BlankNode, sh:IRI, sh:Literal sh:BlankNodeOrIRI, sh:BlankNodeOrLiteral and sh:IRIOrLiteral")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#nodeKind")
    @OslcTitle(value="Node Kind")
    public URI getNodeKind() {
        return this.nodeKind;
    }

    public void setNodeKind(URI nodeKind) {
        this.nodeKind = nodeKind;
    }

    @OslcDescription(value="sh:node specifies the condition that each value node conforms to the given node shape.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#node")
    @OslcTitle(value="Node")
    public URI getNode() {
        return this.node;
    }

    public void setNode(URI node) {
        this.node = node;
    }

    @OslcDescription(value="specifies the condition that each value node is a member of a provided SHACL list.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#in")
    @OslcTitle(value="In")
    @OslcRdfCollectionType
    public Object[] getIn() {
        return this.in;
    }

    public void setIn(String[] in) {
        this.in = in;
    }

    @OslcDescription(value="The specific values of sh:severity have no impact on the validation, but may be used by user interface tools to categorize validation results.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#severity")
    @OslcReadOnly
    @OslcName(value="severity")
    public URI getSeverity() {
        return this.severity;
    }

    public void setSeverity(URI severity) {
        this.severity = severity;
    }

    @OslcDescription(value="sh:equals specifies the condition that the set of all value nodes is equal to the set of objects of the triples that have the focus node as subject and the value of sh:equals as predicate.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#equals")
    @OslcReadOnly
    @OslcName(value="equals")
    public URI getEquals() {
        return this.equals;
    }

    public void setEquals(URI equals) {
        this.equals = equals;
    }

    @OslcDescription(value="sh:disjoint specifies the condition that the set of value nodes is disjoint with the set of objects of the triples that have the focus node as subject and the value of sh:equals as predicate.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#disjoint")
    @OslcReadOnly
    @OslcName(value="disjoint")
    public URI getDisjoint() {
        return this.disjoint;
    }

    public void setDisjoint(URI disjoint) {
        this.disjoint = disjoint;
    }

    @OslcDescription(value="sh:lessThan specifies the condition that each value node is smaller than all the objects of the triples that have the focus node as subject and the value of sh:lessThan as predicate.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#lessThan")
    @OslcReadOnly
    @OslcName(value="lessThan")
    public URI getLessThan() {
        return this.lessThan;
    }

    public void setLessThan(URI lessThan) {
        this.lessThan = lessThan;
    }

    @OslcDescription(value="sh:lessThanOrEquals specifies the condition that each value node is smaller than or equal to all the objects of the triples that have the focus node as subject and the value of sh:lessThanOrEquals as predicate.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#lessThanOrEquals")
    @OslcReadOnly
    @OslcName(value="lessThanOrEquals")
    public URI getLessThanOrEquals() {
        return this.lessThanOrEquals;
    }

    public void setLessThanOrEquals(URI lessThanOrEquals) {
        this.lessThanOrEquals = lessThanOrEquals;
    }

    @OslcDescription(value="sh:hasValue specifies the condition that at least one value node is equal to the given RDF term.")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/shacl#hasValue")
    @OslcReadOnly
    @OslcName(value="hasValue")
    public URI getHasValue() {
        return this.hasValue;
    }

    public void setHasValue(URI hasValue) {
        this.hasValue = hasValue;
    }

    public void setDeactivated(Boolean deactivated) {
        this.deactivated = deactivated;
    }

    private Object[] appendValue(Object[] obj, Object newObj) {
        ArrayList<Object> temp = new ArrayList<Object>(Arrays.asList(obj));
        temp.add(newObj);
        return temp.toArray();
    }
}

