/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.shacl;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValue;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValues;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcMaxSize;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreDuplicatePropertyDefinitionException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreInvalidPropertyDefinitionException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreMissingAnnotationException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreMissingSetMethodException;
import org.eclipse.lyo.oslc4j.core.model.IReifiedResource;
import org.eclipse.lyo.oslc4j.core.model.InheritedMethodAnnotationHelper;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.eclipse.lyo.shacl.DataType;
import org.eclipse.lyo.shacl.Property;
import org.eclipse.lyo.shacl.Shape;
import org.eclipse.lyo.shacl.annotations.RDFType;
import org.eclipse.lyo.shacl.annotations.RdfsIsDefinedBy;
import org.eclipse.lyo.shacl.annotations.RdfsLabel;
import org.eclipse.lyo.shacl.annotations.ShaclClassType;
import org.eclipse.lyo.shacl.annotations.ShaclClosed;
import org.eclipse.lyo.shacl.annotations.ShaclDataType;
import org.eclipse.lyo.shacl.annotations.ShaclDescription;
import org.eclipse.lyo.shacl.annotations.ShaclDisjoint;
import org.eclipse.lyo.shacl.annotations.ShaclEquals;
import org.eclipse.lyo.shacl.annotations.ShaclGroup;
import org.eclipse.lyo.shacl.annotations.ShaclHasValue;
import org.eclipse.lyo.shacl.annotations.ShaclIgnoredProperties;
import org.eclipse.lyo.shacl.annotations.ShaclIn;
import org.eclipse.lyo.shacl.annotations.ShaclLanguageIn;
import org.eclipse.lyo.shacl.annotations.ShaclLessThan;
import org.eclipse.lyo.shacl.annotations.ShaclLessThanOrEquals;
import org.eclipse.lyo.shacl.annotations.ShaclMaxCount;
import org.eclipse.lyo.shacl.annotations.ShaclMaxExclusive;
import org.eclipse.lyo.shacl.annotations.ShaclMaxInclusive;
import org.eclipse.lyo.shacl.annotations.ShaclMaxLength;
import org.eclipse.lyo.shacl.annotations.ShaclMinCount;
import org.eclipse.lyo.shacl.annotations.ShaclMinExclusive;
import org.eclipse.lyo.shacl.annotations.ShaclMinInclusive;
import org.eclipse.lyo.shacl.annotations.ShaclMinLength;
import org.eclipse.lyo.shacl.annotations.ShaclName;
import org.eclipse.lyo.shacl.annotations.ShaclNode;
import org.eclipse.lyo.shacl.annotations.ShaclOrder;
import org.eclipse.lyo.shacl.annotations.ShaclPattern;
import org.eclipse.lyo.shacl.annotations.ShaclTargetClass;
import org.eclipse.lyo.shacl.annotations.ShaclTargetNode;
import org.eclipse.lyo.shacl.annotations.ShaclTargetObjectsOf;
import org.eclipse.lyo.shacl.annotations.ShaclTargetSubjectsOf;
import org.eclipse.lyo.shacl.annotations.ShaclUniqueLang;

public final class ShaclShapeFactory
extends ResourceShapeFactory {
    private ShaclShapeFactory() {
    }

    public static Shape createShaclShape(Class<?> resourceClass) throws OslcCoreApplicationException, URISyntaxException, ParseException {
        HashSet verifiedClasses = new HashSet();
        verifiedClasses.add(resourceClass);
        return ShaclShapeFactory.createShaclShape(resourceClass, verifiedClasses);
    }

    private static Shape createShaclShape(Class<?> resourceClass, Set<Class<?>> verifiedClasses) throws OslcCoreApplicationException, URISyntaxException, ParseException {
        OslcResourceShape resourceShapeAnnotation = resourceClass.getAnnotation(OslcResourceShape.class);
        if (resourceShapeAnnotation == null) {
            throw new OslcCoreMissingAnnotationException(resourceClass, OslcResourceShape.class);
        }
        OslcNamespace oslcNamespace = resourceClass.getAnnotation(OslcNamespace.class);
        OslcName oslcName = resourceClass.getAnnotation(OslcName.class);
        URI about = new URI(oslcNamespace.value() + oslcName.value());
        Shape shaclShape = new Shape(about);
        ShaclShapeFactory.populateFromClassLevelAnnotations(shaclShape, resourceClass);
        HashSet<String> propertyDefinitions = new HashSet<String>();
        ShaclShapeFactory.createProperties(resourceClass, verifiedClasses, shaclShape, propertyDefinitions, true);
        if (!shaclShape.isReadShaclAnnotations()) {
            shaclShape.setShaclProperties(null);
            shaclShape.setTargetClass(new URI(resourceClass.getAnnotation(OslcNamespace.class).value() + resourceClass.getAnnotation(OslcName.class).value()));
            propertyDefinitions.clear();
            ShaclShapeFactory.createProperties(resourceClass, verifiedClasses, shaclShape, propertyDefinitions, false);
        }
        shaclShape.setReadShaclAnnotations(false);
        return shaclShape;
    }

    private static void populateFromClassLevelAnnotations(Shape shaclShape, Class<?> resourceClass) throws URISyntaxException {
        ShaclIgnoredProperties shaclIgnoredProperties;
        ShaclClosed shaclClosed;
        RDFType rdfTypeAnotation;
        RdfsLabel label;
        RdfsIsDefinedBy isDefinedBy;
        ShaclTargetClass shaclTargetClass;
        ShaclTargetSubjectsOf shaclTargetSubjectsOf;
        ShaclTargetObjectsOf shaclTargetObjectsOf;
        ShaclTargetNode shaclTargetNode = resourceClass.getAnnotation(ShaclTargetNode.class);
        if (shaclTargetNode != null) {
            shaclShape.setTargetNode(new URI(shaclTargetNode.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclTargetObjectsOf = resourceClass.getAnnotation(ShaclTargetObjectsOf.class)) != null) {
            shaclShape.setTargetObjectsOf(new URI(shaclTargetObjectsOf.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclTargetSubjectsOf = resourceClass.getAnnotation(ShaclTargetSubjectsOf.class)) != null) {
            shaclShape.setTargetSubjectsOf(new URI(shaclTargetSubjectsOf.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclTargetClass = resourceClass.getAnnotation(ShaclTargetClass.class)) != null) {
            shaclShape.setTargetClass(new URI(shaclTargetClass.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((isDefinedBy = resourceClass.getAnnotation(RdfsIsDefinedBy.class)) != null) {
            shaclShape.setIsDefinedBy(new URI(isDefinedBy.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((label = resourceClass.getAnnotation(RdfsLabel.class)) != null) {
            shaclShape.setLabel(label.value());
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((rdfTypeAnotation = resourceClass.getAnnotation(RDFType.class)) != null) {
            shaclShape.setType(new URI(rdfTypeAnotation.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclClosed = resourceClass.getAnnotation(ShaclClosed.class)) != null) {
            shaclShape.setClosed(shaclClosed.value());
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclIgnoredProperties = resourceClass.getAnnotation(ShaclIgnoredProperties.class)) != null) {
            List<URI> ignoredPropertiesList = ShaclShapeFactory.populateIgnoredProperties(shaclIgnoredProperties);
            shaclShape.setIgnoredProperties(ignoredPropertiesList);
            shaclShape.setReadShaclAnnotations(true);
        }
    }

    private static List<URI> populateIgnoredProperties(ShaclIgnoredProperties shaclIgnoredProperties) throws URISyntaxException {
        ArrayList<URI> ignoredPropertiesList = new ArrayList<URI>();
        for (String ignoredProperty : shaclIgnoredProperties.values()) {
            ignoredPropertiesList.add(new URI(ignoredProperty));
        }
        return ignoredPropertiesList;
    }

    private static void createProperties(Class<?> resourceClass, Set<Class<?>> verifiedClasses, Shape shaclShape, Set<String> propertyDefinitions, boolean chooseShacl) throws OslcCoreDuplicatePropertyDefinitionException, URISyntaxException, OslcCoreApplicationException, OslcCoreMissingSetMethodException, ParseException {
        for (Method method : resourceClass.getMethods()) {
            if (!ShaclShapeFactory.isValidAccessorMethod(method, resourceClass, propertyDefinitions)) continue;
            OslcPropertyDefinition propertyDefinitionAnnotation = (OslcPropertyDefinition)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcPropertyDefinition.class);
            ShaclShapeFactory.createPropertiesInternal(resourceClass, verifiedClasses, shaclShape, propertyDefinitions, chooseShacl, method, propertyDefinitionAnnotation, propertyDefinitionAnnotation.value());
        }
    }

    private static boolean isValidAccessorMethod(Method method, Class<?> resourceClass, Set<String> propertyDefinitions) throws SecurityException, OslcCoreDuplicatePropertyDefinitionException {
        if (method.getParameterTypes().length == 0) {
            OslcPropertyDefinition propertyDefinitionAnnotation;
            String methodName = method.getName();
            int methodNameLength = methodName.length();
            if ((methodName.startsWith("get") && methodNameLength > METHOD_NAME_START_GET_LENGTH || methodName.startsWith("is") && methodNameLength > METHOD_NAME_START_IS_LENGTH) && !method.getReturnType().equals(Void.TYPE) && (propertyDefinitionAnnotation = (OslcPropertyDefinition)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcPropertyDefinition.class)) != null) {
                String propertyDefinition = propertyDefinitionAnnotation.value();
                if (propertyDefinitions.contains(propertyDefinition)) {
                    throw new OslcCoreDuplicatePropertyDefinitionException(resourceClass, propertyDefinitionAnnotation);
                }
                return true;
            }
        }
        return false;
    }

    private static void createPropertiesInternal(Class<?> resourceClass, Set<Class<?>> verifiedClasses, Shape shaclShape, Set<String> propertyDefinitions, boolean chooseShacl, Method method, OslcPropertyDefinition propertyDefinitionAnnotation, String propertyDefinition) throws URISyntaxException, OslcCoreApplicationException, ParseException, OslcCoreMissingSetMethodException {
        propertyDefinitions.add(propertyDefinition);
        if (chooseShacl) {
            Property property = ShaclShapeFactory.createPropertiesFromShaclAnnotations(resourceClass, method, propertyDefinitionAnnotation, verifiedClasses, shaclShape);
            shaclShape.addProperty(property);
        } else {
            Property property = ShaclShapeFactory.createPropertiesFromOslcAnnotations(resourceClass, method, propertyDefinitionAnnotation, verifiedClasses);
            shaclShape.addProperty(property);
        }
        ShaclShapeFactory.validateSetMethodExists(resourceClass, (Method)method);
    }

    private static Class<?> createPropertyCommon(Class<?> resourceClass, Method method, OslcPropertyDefinition propertyDefinitionAnnotation, Set<Class<?>> verifiedClasses) throws OslcCoreApplicationException, URISyntaxException {
        Type actualTypeArgument;
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Type genericType;
        OslcName nameAnnotation = (OslcName)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcName.class);
        String name = nameAnnotation != null ? nameAnnotation.value() : ShaclShapeFactory.getDefaultPropertyName((Method)method);
        String propertyDefinition = propertyDefinitionAnnotation.value();
        if (!propertyDefinition.endsWith(name)) {
            throw new OslcCoreInvalidPropertyDefinitionException(resourceClass, method, propertyDefinitionAnnotation);
        }
        Class<?> returnType = method.getReturnType();
        Class componentType = ShaclShapeFactory.getComponentType(resourceClass, (Method)method, returnType);
        if (IReifiedResource.class.isAssignableFrom(componentType) && (genericType = componentType.getGenericSuperclass()) instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && (actualTypeArgument = actualTypeArguments[0]) instanceof Class) {
            componentType = (Class)actualTypeArgument;
        }
        return componentType;
    }

    private static Property createPropertiesFromOslcAnnotations(Class<?> resourceClass, Method method, OslcPropertyDefinition propertyDefinitionAnnotation, Set<Class<?>> verifiedClasses) throws URISyntaxException, OslcCoreApplicationException, ParseException {
        OslcRange oslcRange;
        OslcValueShape oslcValueShape;
        OslcDescription oslcDescription;
        OslcName oslcName;
        OslcMaxSize oslcMaxSize;
        OslcOccurs oslcOccurs;
        Class<?> componentType = ShaclShapeFactory.createPropertyCommon(resourceClass, method, propertyDefinitionAnnotation, verifiedClasses);
        Property property = new Property();
        property.setPath(new URI(propertyDefinitionAnnotation.value()));
        ValueType valueType = null;
        OslcValueType valueTypeAnnotation = (OslcValueType)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcValueType.class);
        if (valueTypeAnnotation != null) {
            OslcAllowedValues oslcAllowedValues;
            valueType = valueTypeAnnotation.value();
            ShaclShapeFactory.validateUserSpecifiedValueType(resourceClass, (Method)method, (ValueType)valueType, null, componentType);
            property.setDataType(new URI(valueType.toString()));
            OslcAllowedValue oslcAllowedValue = (OslcAllowedValue)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcAllowedValue.class);
            if (oslcAllowedValue != null) {
                property.setIn(oslcAllowedValue.value());
            }
            if ((oslcAllowedValues = (OslcAllowedValues)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcAllowedValues.class)) != null) {
                property.addIn(oslcAllowedValues);
            }
        }
        if ((oslcOccurs = (OslcOccurs)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcOccurs.class)) != null && oslcOccurs.value().equals((Object)Occurs.ExactlyOne)) {
            property.setMaxCount(new BigInteger("1"));
            property.setMinCount(new BigInteger("1"));
        }
        if (oslcOccurs != null && oslcOccurs.value().equals((Object)Occurs.OneOrMany)) {
            property.setMinCount(new BigInteger("1"));
        }
        if (oslcOccurs != null && oslcOccurs.value().equals((Object)Occurs.ZeroOrMany)) {
            property.setMinCount(new BigInteger("0"));
        }
        if (oslcOccurs != null && oslcOccurs.value().equals((Object)Occurs.ZeroOrOne)) {
            property.setMinCount(new BigInteger("0"));
            property.setMaxCount(new BigInteger("1"));
        }
        if ((oslcMaxSize = (OslcMaxSize)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcMaxSize.class)) != null) {
            property.setMaxLength(new BigInteger(String.valueOf(oslcMaxSize.value())));
        }
        if ((oslcName = (OslcName)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcName.class)) != null) {
            property.setName(oslcName.value());
        }
        if ((oslcDescription = (OslcDescription)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcDescription.class)) != null) {
            property.setDescription(oslcDescription.value());
        }
        if ((oslcValueShape = (OslcValueShape)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcValueShape.class)) != null) {
            property.setNode(new URI(oslcValueShape.value()));
        }
        if ((oslcRange = (OslcRange)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcRange.class)) != null) {
            property.setClassType(new URI(oslcRange.value()[0]));
        }
        return property;
    }

    private static Property createPropertiesFromShaclAnnotations(Class<?> resourceClass, Method method, OslcPropertyDefinition propertyDefinitionAnnotation, Set<Class<?>> verifiedClasses, Shape shaclShape) throws URISyntaxException, OslcCoreApplicationException, ParseException {
        ShaclLessThanOrEquals shaclLessThanOrEquals;
        ShaclLessThan shaclLessThan;
        ShaclDisjoint shaclDisjoint;
        ShaclEquals shaclEquals;
        ShaclHasValue shaclHasValue;
        ShaclMaxLength shaclMaxLength;
        ShaclMinLength shaclMinLength;
        ShaclLanguageIn shaclLanguageIn;
        ShaclUniqueLang shaclUniqueLang;
        ShaclPattern shaclPattern;
        ShaclOrder shaclOrder;
        ShaclGroup shaclGroup;
        OslcDescription oslcDescription;
        ShaclName shaclName;
        ShaclNode shaclNode;
        ShaclClassType shaclClass;
        ShaclMaxInclusive maxInclusiveAnnotation;
        ShaclMinInclusive minInclusiveAnnotation;
        ShaclMaxExclusive maxExclusiveAnnotation;
        ShaclMinExclusive minExclusiveAnnotation;
        ShaclMinCount minCountAnnotation;
        ShaclMaxCount maxCountAnnotation;
        ShaclDataType dataTypeAnotation;
        ShaclDescription shaclDescription;
        ShaclIn inAnnotation;
        Property property = new Property();
        property.setPath(new URI(propertyDefinitionAnnotation.value()));
        DataType dataType = null;
        ShaclDataType dataTypeAnnotation = (ShaclDataType)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclDataType.class);
        if (dataTypeAnnotation != null) {
            dataType = dataTypeAnnotation.value();
            property.setDataType(new URI(dataType.toString()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((inAnnotation = (ShaclIn)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclIn.class)) != null) {
            property.setIn(inAnnotation.value());
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclDescription = (ShaclDescription)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclDescription.class)) != null) {
            property.setDescription(shaclDescription.value());
        }
        if ((dataTypeAnotation = (ShaclDataType)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclDataType.class)) != null) {
            property.setDataType(new URI(dataTypeAnotation.value().toString()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((maxCountAnnotation = (ShaclMaxCount)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclMaxCount.class)) != null) {
            property.setMaxCount(new BigInteger(String.valueOf(maxCountAnnotation.value())));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((minCountAnnotation = (ShaclMinCount)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclMinCount.class)) != null) {
            property.setMinCount(new BigInteger(String.valueOf(minCountAnnotation.value())));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((minExclusiveAnnotation = (ShaclMinExclusive)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclMinExclusive.class)) != null) {
            property.setMinExclusive(new BigInteger(String.valueOf(minExclusiveAnnotation.value())));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((maxExclusiveAnnotation = (ShaclMaxExclusive)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclMaxExclusive.class)) != null) {
            property.setMaxExclusive(new BigInteger(String.valueOf(maxExclusiveAnnotation.value())));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((minInclusiveAnnotation = (ShaclMinInclusive)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclMinInclusive.class)) != null) {
            property.setMinInclusive(new BigInteger(String.valueOf(minInclusiveAnnotation.value())));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((maxInclusiveAnnotation = (ShaclMaxInclusive)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclMaxInclusive.class)) != null) {
            property.setMaxInclusive(new BigInteger(String.valueOf(maxInclusiveAnnotation.value())));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclClass = (ShaclClassType)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclClassType.class)) != null) {
            property.setClassType(new URI(shaclClass.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclNode = (ShaclNode)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclNode.class)) != null) {
            property.setNode(new URI(shaclNode.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclName = (ShaclName)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclName.class)) != null) {
            property.setName(shaclName.value());
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((oslcDescription = (OslcDescription)InheritedMethodAnnotationHelper.getAnnotation((Method)method, OslcDescription.class)) != null) {
            property.setDescription(oslcDescription.value());
        }
        if ((shaclGroup = (ShaclGroup)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclGroup.class)) != null) {
            property.setGroup(new URI(shaclGroup.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclOrder = (ShaclOrder)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclOrder.class)) != null) {
            property.setOrder(new BigInteger(String.valueOf(shaclOrder.value())));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclPattern = (ShaclPattern)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclPattern.class)) != null) {
            property.setPattern(shaclPattern.value());
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclUniqueLang = (ShaclUniqueLang)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclUniqueLang.class)) != null) {
            property.setUniqueLang(shaclUniqueLang.value());
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclLanguageIn = (ShaclLanguageIn)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclLanguageIn.class)) != null) {
            property.setLanguageIn(shaclLanguageIn.value());
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclMinLength = (ShaclMinLength)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclMinLength.class)) != null) {
            property.setMinLength(new BigInteger(String.valueOf(shaclMinLength.value())));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclMaxLength = (ShaclMaxLength)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclMaxLength.class)) != null) {
            property.setMaxLength(new BigInteger(String.valueOf(shaclMaxLength.value())));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclHasValue = (ShaclHasValue)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclHasValue.class)) != null) {
            property.setHasValue(new URI(shaclHasValue.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclEquals = (ShaclEquals)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclEquals.class)) != null) {
            property.setEquals(new URI(shaclEquals.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclDisjoint = (ShaclDisjoint)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclDisjoint.class)) != null) {
            property.setDisjoint(new URI(shaclDisjoint.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclLessThan = (ShaclLessThan)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclLessThan.class)) != null) {
            property.setLessThan(new URI(shaclLessThan.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        if ((shaclLessThanOrEquals = (ShaclLessThanOrEquals)InheritedMethodAnnotationHelper.getAnnotation((Method)method, ShaclLessThanOrEquals.class)) != null) {
            property.setLessThanOrEquals(new URI(shaclLessThanOrEquals.value()));
            shaclShape.setReadShaclAnnotations(true);
        }
        return property;
    }
}

