/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.rm;

import java.util.Date;
import java.util.Set;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/rm#")
@OslcName(value="RequirementCollection")
@OslcResourceShape(title="RequirementCollection Shape", describes={"http://open-services.net/ns/rm#RequirementCollection"})
public interface IRequirementCollection {
    public void addSubject(String var1);

    public void addCreator(Link var1);

    public void addContributor(Link var1);

    public void addServiceProvider(Link var1);

    public void addInstanceShape(Link var1);

    public void addElaboratedBy(Link var1);

    public void addElaborates(Link var1);

    public void addSpecifiedBy(Link var1);

    public void addSpecifies(Link var1);

    public void addAffectedBy(Link var1);

    public void addTrackedBy(Link var1);

    public void addImplementedBy(Link var1);

    public void addValidatedBy(Link var1);

    public void addSatisfiedBy(Link var1);

    public void addSatisfies(Link var1);

    public void addDecomposedBy(Link var1);

    public void addDecomposes(Link var1);

    public void addConstrainedBy(Link var1);

    public void addConstrains(Link var1);

    public void addUses(Link var1);

    @OslcName(value="title")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcDescription(value="Title of the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getTitle();

    @OslcName(value="description")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcDescription(value="Descriptive text about resource represented as rich text in XHTML content. SHOULD include only content that is valid and suitable inside an XHTML <div> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getDescription();

    @OslcName(value="identifier")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcDescription(value="A unique identifier for a resource. Typically read-only and assigned by the service provider when a resource is created. Not typically intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getIdentifier();

    @OslcName(value="shortTitle")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#shortTitle")
    @OslcDescription(value="Shorter form of dcterms:title for the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getShortTitle();

    @OslcName(value="subject")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/subject")
    @OslcDescription(value="Tag or keyword for a resource. Each occurrence of a dcterms:subject property denotes an additional tag for the resource.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    @OslcTitle(value="")
    public Set<String> getSubject();

    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcDescription(value="Creator or creators of the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getCreator();

    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcDescription(value="Contributor or contributors to the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getContributor();

    @OslcName(value="created")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcDescription(value="Timestamp of resource creation")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCreated();

    @OslcName(value="modified")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcDescription(value="Timestamp of latest resource modification")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getModified();

    @OslcName(value="serviceProvider")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcDescription(value="A link to the resource's OSLC Service Provider. There may be cases when the subject resource is available from a service provider that implements multiple domain specifications, which could result in multiple values for this property.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getServiceProvider();

    @OslcName(value="instanceShape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcDescription(value="The URI of a Resource Shape that describes the possible properties, occurrence, value types, allowed values and labels. This shape information is useful in displaying the subject resource as well as guiding clients in performing modifications. Instance shapes may be specific to the authenticated user associated with the request that retrieved the resource, the current state of the resource and other factors and thus should not be cached.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getInstanceShape();

    @OslcName(value="elaboratedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#elaboratedBy")
    @OslcDescription(value="The subject is elaborated by the object. For example, a user requirement is elaborated by use case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getElaboratedBy();

    @OslcName(value="elaborates")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#elaborates")
    @OslcDescription(value="The object is elaborated by the subject.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getElaborates();

    @OslcName(value="specifiedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#specifiedBy")
    @OslcDescription(value="The subject is specified by the object. For example, a requirement is elaborated by a model element .")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getSpecifiedBy();

    @OslcName(value="specifies")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#specifies")
    @OslcDescription(value="The object is specified by the subject.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getSpecifies();

    @OslcName(value="affectedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#affectedBy")
    @OslcDescription(value="Requirement is affected by a resource, such as a defect or issue.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getAffectedBy();

    @OslcName(value="trackedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#trackedBy")
    @OslcDescription(value="Resource, such as a change request, which tracks this requirement.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getTrackedBy();

    @OslcName(value="implementedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#implementedBy")
    @OslcDescription(value="Resource, such as a change request, which implements this requirement.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getImplementedBy();

    @OslcName(value="validatedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#validatedBy")
    @OslcDescription(value="Resource, such as a test case, which validates this requirement.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getValidatedBy();

    @OslcName(value="satisfiedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#satisfiedBy")
    @OslcDescription(value="The subject is satisfied by the object. For example, a user requirement is satisfied by a system requirement.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getSatisfiedBy();

    @OslcName(value="satisfies")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#satisfies")
    @OslcDescription(value="The object is satisfied by the subject.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getSatisfies();

    @OslcName(value="decomposedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#decomposedBy")
    @OslcDescription(value="The subject is decomposed by the object. For example, a system requirement is decomposed into a collection of system requirements.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getDecomposedBy();

    @OslcName(value="decomposes")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#decomposes")
    @OslcDescription(value="The object is decomposed by the subject.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getDecomposes();

    @OslcName(value="constrainedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#constrainedBy")
    @OslcDescription(value="The subject is constrained by the object. For example, a functional requirement is constrained by a safety requirement.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getConstrainedBy();

    @OslcName(value="constrains")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#constrains")
    @OslcDescription(value="The object is constrained by the subject.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getConstrains();

    @OslcName(value="uses")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#uses")
    @OslcDescription(value="A collection uses a resource - the resource is in the requirement collection. ")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    @OslcTitle(value="")
    public Set<Link> getUses();

    public void setTitle(String var1);

    public void setDescription(String var1);

    public void setIdentifier(String var1);

    public void setShortTitle(String var1);

    public void setSubject(Set<String> var1);

    public void setCreator(Set<Link> var1);

    public void setContributor(Set<Link> var1);

    public void setCreated(Date var1);

    public void setModified(Date var1);

    public void setServiceProvider(Set<Link> var1);

    public void setInstanceShape(Set<Link> var1);

    public void setElaboratedBy(Set<Link> var1);

    public void setElaborates(Set<Link> var1);

    public void setSpecifiedBy(Set<Link> var1);

    public void setSpecifies(Set<Link> var1);

    public void setAffectedBy(Set<Link> var1);

    public void setTrackedBy(Set<Link> var1);

    public void setImplementedBy(Set<Link> var1);

    public void setValidatedBy(Set<Link> var1);

    public void setSatisfiedBy(Set<Link> var1);

    public void setSatisfies(Set<Link> var1);

    public void setDecomposedBy(Set<Link> var1);

    public void setDecomposes(Set<Link> var1);

    public void setConstrainedBy(Set<Link> var1);

    public void setConstrains(Set<Link> var1);

    public void setUses(Set<Link> var1);
}

