/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.promcode;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.promcode.IReport;
import org.eclipse.lyo.oslc.domains.promcode.ManagedItemCollection;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/promcode#")
@OslcName(value="Report")
@OslcResourceShape(title="Report Shape", description="A Report is a resource which is a subclass of ManagedItemCollection to describe a report. A Report is associated to corresponding Plan.", describes={"http://open-services.net/ns/promcode#Report"})
public class Report
extends ManagedItemCollection
implements IReport {
    private Link oslc_promcodeBelongsTo;
    private Set<Link> oslc_promcodeCollects = new HashSet<Link>();
    private Link correspondsTo;
    private Set<Link> includes = new HashSet<Link>();

    public Report() {
    }

    public Report(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"report", Report.class);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean asLocalResource) {
        Object result = "";
        result = asLocalResource ? (String)result + "{a Local Report Resource} - update Report.toString() to present resource as desired." : String.valueOf(this.getAbout());
        return result;
    }

    @Override
    public void addOslc_promcodeCollects(Link collects) {
        this.oslc_promcodeCollects.add(collects);
    }

    @Override
    public void addIncludes(Link includes) {
        this.includes.add(includes);
    }

    @Override
    @OslcName(value="belongsTo")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#belongsTo")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/promcode#Project"})
    @OslcReadOnly(value=false)
    public Link getOslc_promcodeBelongsTo() {
        return this.oslc_promcodeBelongsTo;
    }

    @Override
    @OslcName(value="collects")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#collects")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/promcode#Artifact", "http://open-services.net/ns/promcode#WorkItem", "http://open-services.net/ns/promcode#ScopeItem"})
    @OslcReadOnly(value=false)
    public Set<Link> getOslc_promcodeCollects() {
        return this.oslc_promcodeCollects;
    }

    @Override
    @OslcName(value="correspondsTo")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#correspondsTo")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/promcode#Plan"})
    @OslcReadOnly(value=false)
    public Link getCorrespondsTo() {
        return this.correspondsTo;
    }

    @Override
    @OslcName(value="includes")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#includes")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/promcode#Measurement"})
    @OslcReadOnly(value=false)
    public Set<Link> getIncludes() {
        return this.includes;
    }

    @Override
    public void setOslc_promcodeBelongsTo(Link belongsTo) {
        this.oslc_promcodeBelongsTo = belongsTo;
    }

    @Override
    public void setOslc_promcodeCollects(Set<Link> collects) {
        this.oslc_promcodeCollects.clear();
        if (collects != null) {
            this.oslc_promcodeCollects.addAll(collects);
        }
    }

    @Override
    public void setCorrespondsTo(Link correspondsTo) {
        this.correspondsTo = correspondsTo;
    }

    @Override
    public void setIncludes(Set<Link> includes) {
        this.includes.clear();
        if (includes != null) {
            this.includes.addAll(includes);
        }
    }
}

