/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.promcode;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.promcode.IManagedItemCollection;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/promcode#")
@OslcName(value="ManagedItemCollection")
@OslcResourceShape(title="ManagedItemCollection Shape", description="A managed item collection is container of managed items. Any combination of subclass such as a scope item, work item, artifact or issue can be hold in a ManagedItemCollection as a snapshot. ManagedItemCollection has concrete subclasses such as Plan, Report and IssueCollection.", describes={"http://open-services.net/ns/promcode#ManagedItemCollection"})
public class ManagedItemCollection
extends AbstractResource
implements IManagedItemCollection {
    private Date date;
    private String description;
    private String identifier;
    private String source;
    private String title;
    private Link belongsTo;
    private Set<Link> collects = new HashSet<Link>();

    public ManagedItemCollection() {
    }

    public ManagedItemCollection(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"managedItemCollection", ManagedItemCollection.class);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean asLocalResource) {
        Object result = "";
        result = asLocalResource ? (String)result + "{a Local ManagedItemCollection Resource} - update ManagedItemCollection.toString() to present resource as desired." : String.valueOf(this.getAbout());
        return result;
    }

    @Override
    public void addCollects(Link collects) {
        this.collects.add(collects);
    }

    @Override
    @OslcName(value="date")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/date")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getDate() {
        return this.date;
    }

    @Override
    @OslcName(value="description")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getDescription() {
        return this.description;
    }

    @Override
    @OslcName(value="identifier")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @OslcName(value="source")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/source")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getSource() {
        return this.source;
    }

    @Override
    @OslcName(value="title")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getTitle() {
        return this.title;
    }

    @Override
    @OslcName(value="belongsTo")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#belongsTo")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/promcode#Project"})
    @OslcReadOnly(value=false)
    public Link getBelongsTo() {
        return this.belongsTo;
    }

    @Override
    @OslcName(value="collects")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#collects")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/promcode#Issue", "http://open-services.net/ns/promcode#Risk", "http://open-services.net/ns/promcode#Artifact", "http://open-services.net/ns/promcode#WorkItem", "http://open-services.net/ns/promcode#ScopeItem"})
    @OslcReadOnly(value=false)
    public Set<Link> getCollects() {
        return this.collects;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setBelongsTo(Link belongsTo) {
        this.belongsTo = belongsTo;
    }

    @Override
    public void setCollects(Set<Link> collects) {
        this.collects.clear();
        if (collects != null) {
            this.collects.addAll(collects);
        }
    }
}

