/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.promcode;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.promcode.IIssueCollection;
import org.eclipse.lyo.oslc.domains.promcode.ManagedItemCollection;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/promcode#")
@OslcName(value="IssueCollection")
@OslcResourceShape(title="IssueCollection Shape", description="An IssueCollection is a resource which is a subclass of ManagedItemCollection. An IssueCollection only collects Issues. All of Issues raised in a project should be collected by an IssueCollection.", describes={"http://open-services.net/ns/promcode#IssueCollection"})
public class IssueCollection
extends ManagedItemCollection
implements IIssueCollection {
    private Link oslc_promcodeBelongsTo;
    private Set<Link> oslc_promcodeCollects = new HashSet<Link>();

    public IssueCollection() {
    }

    public IssueCollection(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"issueCollection", IssueCollection.class);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean asLocalResource) {
        Object result = "";
        result = asLocalResource ? (String)result + "{a Local IssueCollection Resource} - update IssueCollection.toString() to present resource as desired." : String.valueOf(this.getAbout());
        return result;
    }

    @Override
    public void addOslc_promcodeCollects(Link collects) {
        this.oslc_promcodeCollects.add(collects);
    }

    @Override
    @OslcName(value="belongsTo")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#belongsTo")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/promcode#Project"})
    @OslcReadOnly(value=false)
    public Link getOslc_promcodeBelongsTo() {
        return this.oslc_promcodeBelongsTo;
    }

    @Override
    @OslcName(value="collects")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#collects")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/promcode#Issue"})
    @OslcReadOnly(value=false)
    public Set<Link> getOslc_promcodeCollects() {
        return this.oslc_promcodeCollects;
    }

    @Override
    public void setOslc_promcodeBelongsTo(Link belongsTo) {
        this.oslc_promcodeBelongsTo = belongsTo;
    }

    @Override
    public void setOslc_promcodeCollects(Set<Link> collects) {
        this.oslc_promcodeCollects.clear();
        if (collects != null) {
            this.oslc_promcodeCollects.addAll(collects);
        }
    }
}

