/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.auto;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.auto.IAutomationResult;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/auto#")
@OslcName(value="AutomationResult")
@OslcResourceShape(title="AutomationResult Shape", describes={"http://open-services.net/ns/auto#AutomationResult"})
public class AutomationResult
extends AbstractResource
implements IAutomationResult {
    private Set<Link> contributor = new HashSet<Link>();
    private Date created;
    private Set<Link> creator = new HashSet<Link>();
    private String identifier;
    private Date modified;
    private Set<Link> type = new HashSet<Link>();
    private Set<String> subject = new HashSet<String>();
    private String title;
    private Set<Link> instanceShape = new HashSet<Link>();
    private Set<Link> serviceProvider = new HashSet<Link>();
    private Set<Link> state = new HashSet<Link>();
    private Link desiredState;
    private Set<Link> verdict = new HashSet<Link>();
    private Set<Link> contribution = new HashSet<Link>();
    private Set<Link> inputParameter = new HashSet<Link>();
    private Set<Link> outputParameter = new HashSet<Link>();
    private Link producedByAutomationRequest;
    private Link reportsOnAutomationPlan;

    public AutomationResult() {
    }

    public AutomationResult(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"automationResult", AutomationResult.class);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean asLocalResource) {
        Object result = "";
        result = asLocalResource ? (String)result + "{a Local AutomationResult Resource} - update AutomationResult.toString() to present resource as desired." : String.valueOf(this.getAbout());
        return result;
    }

    @Override
    public void addContributor(Link contributor) {
        this.contributor.add(contributor);
    }

    @Override
    public void addCreator(Link creator) {
        this.creator.add(creator);
    }

    @Override
    public void addType(Link type) {
        this.type.add(type);
    }

    @Override
    public void addSubject(String subject) {
        this.subject.add(subject);
    }

    @Override
    public void addInstanceShape(Link instanceShape) {
        this.instanceShape.add(instanceShape);
    }

    @Override
    public void addServiceProvider(Link serviceProvider) {
        this.serviceProvider.add(serviceProvider);
    }

    @Override
    public void addState(Link state) {
        this.state.add(state);
    }

    @Override
    public void addVerdict(Link verdict) {
        this.verdict.add(verdict);
    }

    @Override
    public void addContribution(Link contribution) {
        this.contribution.add(contribution);
    }

    @Override
    public void addInputParameter(Link inputParameter) {
        this.inputParameter.add(inputParameter);
    }

    @Override
    public void addOutputParameter(Link outputParameter) {
        this.outputParameter.add(outputParameter);
    }

    @Override
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcDescription(value="Contributor or contributors to the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getContributor() {
        return this.contributor;
    }

    @Override
    @OslcName(value="created")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcDescription(value="Timestamp of resource creation")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCreated() {
        return this.created;
    }

    @Override
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcDescription(value="Creator or creators of the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getCreator() {
        return this.creator;
    }

    @Override
    @OslcName(value="identifier")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcDescription(value="A unique identifier for a resource. Typically read-only and assigned by the service provider when a resource is created. Not typically intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @OslcName(value="modified")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcDescription(value="Timestamp of latest resource modification")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getModified() {
        return this.modified;
    }

    @Override
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcDescription(value="The resource type URIs")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    public Set<Link> getType() {
        return this.type;
    }

    @Override
    @OslcName(value="subject")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/subject")
    @OslcDescription(value="Tag or keyword for a resource. Each occurrence of a dcterms:subject property denotes an additional tag for the resource.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    @OslcTitle(value="")
    public Set<String> getSubject() {
        return this.subject;
    }

    @Override
    @OslcName(value="title")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcDescription(value="Title of the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getTitle() {
        return this.title;
    }

    @Override
    @OslcName(value="instanceShape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcDescription(value="The URI of a Resource Shape that describes the possible properties, occurrence, value types, allowed values and labels. This shape information is useful in displaying the subject resource as well as guiding clients in performing modifications. Instance shapes may be specific to the authenticated user associated with the request that retrieved the resource, the current state of the resource and other factors and thus should not be cached.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getInstanceShape() {
        return this.instanceShape;
    }

    @Override
    @OslcName(value="serviceProvider")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcDescription(value="A link to the resource's OSLC Service Provider. There may be cases when the subject resource is available from a service provider that implements multiple domain specifications, which could result in multiple values for this property.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    @OslcName(value="state")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#state")
    @OslcDescription(value="Used to indicate the state of the automation request based on values defined by the service provider. Most often a read-only property. It is expected that this will be a resource reference to a definition of a valid automation request state on the service provider.")
    @OslcOccurs(value=Occurs.OneOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=true)
    public Set<Link> getState() {
        return this.state;
    }

    @Override
    @OslcName(value="desiredState")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#desiredState")
    @OslcDescription(value="Used to indicate the desired state of the Automation Request based on values defined by the service provider. It is expected that this will be a resource reference to a definition of a valid automation request state on the service provider.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    public Link getDesiredState() {
        return this.desiredState;
    }

    @Override
    @OslcName(value="verdict")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#verdict")
    @OslcDescription(value="Used to indicate the verdict of the automation result based on values defined by the service provider. Most often a read-only property. It is expected that this will be a resource reference to a definition of a valid automation result verdict on the service provider.")
    @OslcOccurs(value=Occurs.OneOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    public Set<Link> getVerdict() {
        return this.verdict;
    }

    @Override
    @OslcName(value="contribution")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#contribution")
    @OslcDescription(value="A result contribution associated with this automation result. It is recommended that the contribution be an inline resource which can be retrieved with the automation result. The recommended attributes beyond the contribution itself are dcterms:title, dcterms:description and dcterms:type to provide a description of the contribution which would be appropriate for display in a simple UI for an automation result.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    public Set<Link> getContribution() {
        return this.contribution;
    }

    @Override
    @OslcName(value="inputParameter")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#inputParameter")
    @OslcDescription(value="Parameters provided when Automation Requests are created. These include parameters provided by the creator of the Automation Request (whether by delegated UI or HTTP POST) and MAY include additional parameters added by the service provider during Automation Request creation. See the definition of the oslc_auto:parameterDefinition attribute of the Automation Plan for additional guidance on determining which parameters are required. Creators of Automation Requests MAY provide parameters beyond those defined in the Automation Plan without guarantee the service provider will recognize or honor them. It is expected that this attribute is write-able on Automation Request creation and read-only thereafter.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/auto#ParameterInstance"})
    @OslcReadOnly(value=false)
    public Set<Link> getInputParameter() {
        return this.inputParameter;
    }

    @Override
    @OslcName(value="outputParameter")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#outputParameter")
    @OslcDescription(value="Automation Result output parameters are parameters associated with the automation execution which produced this Result. This includes the final value of all parameters used to initiate the execution and any additional parameters which may have been created during automation execution by the service provider or external agents. The value of a given oslc_auto:outputParameter MAY change as the execution proceeds. Point-in-time accuracy of the values of output parameters is not covered by this specification. Once the Automation Result is in a final state ( oslc_auto:complete or oslc_auto:canceled), the oslc_auto:outputParameter values MUST NOT change.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/auto#ParameterInstance"})
    @OslcReadOnly(value=false)
    public Set<Link> getOutputParameter() {
        return this.outputParameter;
    }

    @Override
    @OslcName(value="producedByAutomationRequest")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#producedByAutomationRequest")
    @OslcDescription(value="Automation Request which produced the Automation Result. It is likely that the target resource will be an oslc_auto:AutomationRequest but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/auto#AutomationRequest"})
    @OslcReadOnly(value=false)
    public Link getProducedByAutomationRequest() {
        return this.producedByAutomationRequest;
    }

    @Override
    @OslcName(value="reportsOnAutomationPlan")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#reportsOnAutomationPlan")
    @OslcDescription(value="Automation Plan which the Automation Result reports on. It is likely that the target resource will be an oslc_auto:AutomationPlan but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/auto#AutomationPlan"})
    @OslcReadOnly(value=false)
    public Link getReportsOnAutomationPlan() {
        return this.reportsOnAutomationPlan;
    }

    @Override
    public void setContributor(Set<Link> contributor) {
        this.contributor.clear();
        if (contributor != null) {
            this.contributor.addAll(contributor);
        }
    }

    @Override
    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    public void setCreator(Set<Link> creator) {
        this.creator.clear();
        if (creator != null) {
            this.creator.addAll(creator);
        }
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Override
    public void setType(Set<Link> type) {
        this.type.clear();
        if (type != null) {
            this.type.addAll(type);
        }
    }

    @Override
    public void setSubject(Set<String> subject) {
        this.subject.clear();
        if (subject != null) {
            this.subject.addAll(subject);
        }
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setInstanceShape(Set<Link> instanceShape) {
        this.instanceShape.clear();
        if (instanceShape != null) {
            this.instanceShape.addAll(instanceShape);
        }
    }

    @Override
    public void setServiceProvider(Set<Link> serviceProvider) {
        this.serviceProvider.clear();
        if (serviceProvider != null) {
            this.serviceProvider.addAll(serviceProvider);
        }
    }

    @Override
    public void setState(Set<Link> state) {
        this.state.clear();
        if (state != null) {
            this.state.addAll(state);
        }
    }

    @Override
    public void setDesiredState(Link desiredState) {
        this.desiredState = desiredState;
    }

    @Override
    public void setVerdict(Set<Link> verdict) {
        this.verdict.clear();
        if (verdict != null) {
            this.verdict.addAll(verdict);
        }
    }

    @Override
    public void setContribution(Set<Link> contribution) {
        this.contribution.clear();
        if (contribution != null) {
            this.contribution.addAll(contribution);
        }
    }

    @Override
    public void setInputParameter(Set<Link> inputParameter) {
        this.inputParameter.clear();
        if (inputParameter != null) {
            this.inputParameter.addAll(inputParameter);
        }
    }

    @Override
    public void setOutputParameter(Set<Link> outputParameter) {
        this.outputParameter.clear();
        if (outputParameter != null) {
            this.outputParameter.addAll(outputParameter);
        }
    }

    @Override
    public void setProducedByAutomationRequest(Link producedByAutomationRequest) {
        this.producedByAutomationRequest = producedByAutomationRequest;
    }

    @Override
    public void setReportsOnAutomationPlan(Link reportsOnAutomationPlan) {
        this.reportsOnAutomationPlan = reportsOnAutomationPlan;
    }
}

