/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.rm;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.rm.IRequirementCollection;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/rm#")
@OslcName(value="RequirementCollection")
@OslcResourceShape(title="RequirementCollection Shape", describes={"http://open-services.net/ns/rm#RequirementCollection"})
public class RequirementCollection
extends AbstractResource
implements IRequirementCollection {
    private String title;
    private String description;
    private String identifier;
    private String shortTitle;
    private Set<String> subject = new HashSet<String>();
    private Set<Link> creator = new HashSet<Link>();
    private Set<Link> contributor = new HashSet<Link>();
    private Date created;
    private Date modified;
    private Set<Link> serviceProvider = new HashSet<Link>();
    private Set<Link> instanceShape = new HashSet<Link>();
    private Set<Link> elaboratedBy = new HashSet<Link>();
    private Set<Link> elaborates = new HashSet<Link>();
    private Set<Link> specifiedBy = new HashSet<Link>();
    private Set<Link> specifies = new HashSet<Link>();
    private Set<Link> affectedBy = new HashSet<Link>();
    private Set<Link> trackedBy = new HashSet<Link>();
    private Set<Link> implementedBy = new HashSet<Link>();
    private Set<Link> validatedBy = new HashSet<Link>();
    private Set<Link> satisfiedBy = new HashSet<Link>();
    private Set<Link> satisfies = new HashSet<Link>();
    private Set<Link> decomposedBy = new HashSet<Link>();
    private Set<Link> decomposes = new HashSet<Link>();
    private Set<Link> constrainedBy = new HashSet<Link>();
    private Set<Link> constrains = new HashSet<Link>();
    private Set<Link> uses = new HashSet<Link>();

    public RequirementCollection() {
    }

    public RequirementCollection(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"requirementCollection", RequirementCollection.class);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean asLocalResource) {
        Object result = "";
        result = asLocalResource ? (String)result + "{a Local RequirementCollection Resource} - update RequirementCollection.toString() to present resource as desired." : String.valueOf(this.getAbout());
        return result;
    }

    @Override
    public void addSubject(String subject) {
        this.subject.add(subject);
    }

    @Override
    public void addCreator(Link creator) {
        this.creator.add(creator);
    }

    @Override
    public void addContributor(Link contributor) {
        this.contributor.add(contributor);
    }

    @Override
    public void addServiceProvider(Link serviceProvider) {
        this.serviceProvider.add(serviceProvider);
    }

    @Override
    public void addInstanceShape(Link instanceShape) {
        this.instanceShape.add(instanceShape);
    }

    @Override
    public void addElaboratedBy(Link elaboratedBy) {
        this.elaboratedBy.add(elaboratedBy);
    }

    @Override
    public void addElaborates(Link elaborates) {
        this.elaborates.add(elaborates);
    }

    @Override
    public void addSpecifiedBy(Link specifiedBy) {
        this.specifiedBy.add(specifiedBy);
    }

    @Override
    public void addSpecifies(Link specifies) {
        this.specifies.add(specifies);
    }

    @Override
    public void addAffectedBy(Link affectedBy) {
        this.affectedBy.add(affectedBy);
    }

    @Override
    public void addTrackedBy(Link trackedBy) {
        this.trackedBy.add(trackedBy);
    }

    @Override
    public void addImplementedBy(Link implementedBy) {
        this.implementedBy.add(implementedBy);
    }

    @Override
    public void addValidatedBy(Link validatedBy) {
        this.validatedBy.add(validatedBy);
    }

    @Override
    public void addSatisfiedBy(Link satisfiedBy) {
        this.satisfiedBy.add(satisfiedBy);
    }

    @Override
    public void addSatisfies(Link satisfies) {
        this.satisfies.add(satisfies);
    }

    @Override
    public void addDecomposedBy(Link decomposedBy) {
        this.decomposedBy.add(decomposedBy);
    }

    @Override
    public void addDecomposes(Link decomposes) {
        this.decomposes.add(decomposes);
    }

    @Override
    public void addConstrainedBy(Link constrainedBy) {
        this.constrainedBy.add(constrainedBy);
    }

    @Override
    public void addConstrains(Link constrains) {
        this.constrains.add(constrains);
    }

    @Override
    public void addUses(Link uses) {
        this.uses.add(uses);
    }

    @Override
    @OslcName(value="title")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcDescription(value="Title of the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getTitle() {
        return this.title;
    }

    @Override
    @OslcName(value="description")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcDescription(value="Descriptive text about resource represented as rich text in XHTML content. SHOULD include only content that is valid and suitable inside an XHTML <div> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getDescription() {
        return this.description;
    }

    @Override
    @OslcName(value="identifier")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcDescription(value="A unique identifier for a resource. Typically read-only and assigned by the service provider when a resource is created. Not typically intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @OslcName(value="shortTitle")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#shortTitle")
    @OslcDescription(value="Shorter form of dcterms:title for the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getShortTitle() {
        return this.shortTitle;
    }

    @Override
    @OslcName(value="subject")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/subject")
    @OslcDescription(value="Tag or keyword for a resource. Each occurrence of a dcterms:subject property denotes an additional tag for the resource.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    @OslcTitle(value="")
    public Set<String> getSubject() {
        return this.subject;
    }

    @Override
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcDescription(value="Creator or creators of the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getCreator() {
        return this.creator;
    }

    @Override
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcDescription(value="Contributor or contributors to the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getContributor() {
        return this.contributor;
    }

    @Override
    @OslcName(value="created")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcDescription(value="Timestamp of resource creation")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCreated() {
        return this.created;
    }

    @Override
    @OslcName(value="modified")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcDescription(value="Timestamp of latest resource modification")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getModified() {
        return this.modified;
    }

    @Override
    @OslcName(value="serviceProvider")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcDescription(value="A link to the resource's OSLC Service Provider. There may be cases when the subject resource is available from a service provider that implements multiple domain specifications, which could result in multiple values for this property.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    @OslcName(value="instanceShape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcDescription(value="The URI of a Resource Shape that describes the possible properties, occurrence, value types, allowed values and labels. This shape information is useful in displaying the subject resource as well as guiding clients in performing modifications. Instance shapes may be specific to the authenticated user associated with the request that retrieved the resource, the current state of the resource and other factors and thus should not be cached.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getInstanceShape() {
        return this.instanceShape;
    }

    @Override
    @OslcName(value="elaboratedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#elaboratedBy")
    @OslcDescription(value="The subject is elaborated by the object. For example, a user requirement is elaborated by use case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getElaboratedBy() {
        return this.elaboratedBy;
    }

    @Override
    @OslcName(value="elaborates")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#elaborates")
    @OslcDescription(value="The object is elaborated by the subject.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getElaborates() {
        return this.elaborates;
    }

    @Override
    @OslcName(value="specifiedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#specifiedBy")
    @OslcDescription(value="The subject is specified by the object. For example, a requirement is elaborated by a model element .")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getSpecifiedBy() {
        return this.specifiedBy;
    }

    @Override
    @OslcName(value="specifies")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#specifies")
    @OslcDescription(value="The object is specified by the subject.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getSpecifies() {
        return this.specifies;
    }

    @Override
    @OslcName(value="affectedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#affectedBy")
    @OslcDescription(value="Requirement is affected by a resource, such as a defect or issue.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getAffectedBy() {
        return this.affectedBy;
    }

    @Override
    @OslcName(value="trackedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#trackedBy")
    @OslcDescription(value="Resource, such as a change request, which tracks this requirement.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getTrackedBy() {
        return this.trackedBy;
    }

    @Override
    @OslcName(value="implementedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#implementedBy")
    @OslcDescription(value="Resource, such as a change request, which implements this requirement.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getImplementedBy() {
        return this.implementedBy;
    }

    @Override
    @OslcName(value="validatedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#validatedBy")
    @OslcDescription(value="Resource, such as a test case, which validates this requirement.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getValidatedBy() {
        return this.validatedBy;
    }

    @Override
    @OslcName(value="satisfiedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#satisfiedBy")
    @OslcDescription(value="The subject is satisfied by the object. For example, a user requirement is satisfied by a system requirement.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getSatisfiedBy() {
        return this.satisfiedBy;
    }

    @Override
    @OslcName(value="satisfies")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#satisfies")
    @OslcDescription(value="The object is satisfied by the subject.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getSatisfies() {
        return this.satisfies;
    }

    @Override
    @OslcName(value="decomposedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#decomposedBy")
    @OslcDescription(value="The subject is decomposed by the object. For example, a system requirement is decomposed into a collection of system requirements.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getDecomposedBy() {
        return this.decomposedBy;
    }

    @Override
    @OslcName(value="decomposes")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#decomposes")
    @OslcDescription(value="The object is decomposed by the subject.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getDecomposes() {
        return this.decomposes;
    }

    @Override
    @OslcName(value="constrainedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#constrainedBy")
    @OslcDescription(value="The subject is constrained by the object. For example, a functional requirement is constrained by a safety requirement.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getConstrainedBy() {
        return this.constrainedBy;
    }

    @Override
    @OslcName(value="constrains")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#constrains")
    @OslcDescription(value="The object is constrained by the subject.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getConstrains() {
        return this.constrains;
    }

    @Override
    @OslcName(value="uses")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#uses")
    @OslcDescription(value="A collection uses a resource - the resource is in the requirement collection. ")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    @OslcTitle(value="")
    public Set<Link> getUses() {
        return this.uses;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    @Override
    public void setSubject(Set<String> subject) {
        this.subject.clear();
        if (subject != null) {
            this.subject.addAll(subject);
        }
    }

    @Override
    public void setCreator(Set<Link> creator) {
        this.creator.clear();
        if (creator != null) {
            this.creator.addAll(creator);
        }
    }

    @Override
    public void setContributor(Set<Link> contributor) {
        this.contributor.clear();
        if (contributor != null) {
            this.contributor.addAll(contributor);
        }
    }

    @Override
    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Override
    public void setServiceProvider(Set<Link> serviceProvider) {
        this.serviceProvider.clear();
        if (serviceProvider != null) {
            this.serviceProvider.addAll(serviceProvider);
        }
    }

    @Override
    public void setInstanceShape(Set<Link> instanceShape) {
        this.instanceShape.clear();
        if (instanceShape != null) {
            this.instanceShape.addAll(instanceShape);
        }
    }

    @Override
    public void setElaboratedBy(Set<Link> elaboratedBy) {
        this.elaboratedBy.clear();
        if (elaboratedBy != null) {
            this.elaboratedBy.addAll(elaboratedBy);
        }
    }

    @Override
    public void setElaborates(Set<Link> elaborates) {
        this.elaborates.clear();
        if (elaborates != null) {
            this.elaborates.addAll(elaborates);
        }
    }

    @Override
    public void setSpecifiedBy(Set<Link> specifiedBy) {
        this.specifiedBy.clear();
        if (specifiedBy != null) {
            this.specifiedBy.addAll(specifiedBy);
        }
    }

    @Override
    public void setSpecifies(Set<Link> specifies) {
        this.specifies.clear();
        if (specifies != null) {
            this.specifies.addAll(specifies);
        }
    }

    @Override
    public void setAffectedBy(Set<Link> affectedBy) {
        this.affectedBy.clear();
        if (affectedBy != null) {
            this.affectedBy.addAll(affectedBy);
        }
    }

    @Override
    public void setTrackedBy(Set<Link> trackedBy) {
        this.trackedBy.clear();
        if (trackedBy != null) {
            this.trackedBy.addAll(trackedBy);
        }
    }

    @Override
    public void setImplementedBy(Set<Link> implementedBy) {
        this.implementedBy.clear();
        if (implementedBy != null) {
            this.implementedBy.addAll(implementedBy);
        }
    }

    @Override
    public void setValidatedBy(Set<Link> validatedBy) {
        this.validatedBy.clear();
        if (validatedBy != null) {
            this.validatedBy.addAll(validatedBy);
        }
    }

    @Override
    public void setSatisfiedBy(Set<Link> satisfiedBy) {
        this.satisfiedBy.clear();
        if (satisfiedBy != null) {
            this.satisfiedBy.addAll(satisfiedBy);
        }
    }

    @Override
    public void setSatisfies(Set<Link> satisfies) {
        this.satisfies.clear();
        if (satisfies != null) {
            this.satisfies.addAll(satisfies);
        }
    }

    @Override
    public void setDecomposedBy(Set<Link> decomposedBy) {
        this.decomposedBy.clear();
        if (decomposedBy != null) {
            this.decomposedBy.addAll(decomposedBy);
        }
    }

    @Override
    public void setDecomposes(Set<Link> decomposes) {
        this.decomposes.clear();
        if (decomposes != null) {
            this.decomposes.addAll(decomposes);
        }
    }

    @Override
    public void setConstrainedBy(Set<Link> constrainedBy) {
        this.constrainedBy.clear();
        if (constrainedBy != null) {
            this.constrainedBy.addAll(constrainedBy);
        }
    }

    @Override
    public void setConstrains(Set<Link> constrains) {
        this.constrains.clear();
        if (constrains != null) {
            this.constrains.addAll(constrains);
        }
    }

    @Override
    public void setUses(Set<Link> uses) {
        this.uses.clear();
        if (uses != null) {
            this.uses.addAll(uses);
        }
    }
}

