/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.promcode;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.promcode.IWorkItem;
import org.eclipse.lyo.oslc.domains.promcode.ManagedItem;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/promcode#")
@OslcName(value="WorkItem")
@OslcResourceShape(title="WorkItem Shape", description="A work item describes work to be performed in a project delivery contract. It adds detail to the description of work that is described by a scope item. These details typically include cost, schedule, and resource requirements. The set of all work items in a project form a work breakdown structure.", describes={"http://open-services.net/ns/promcode#WorkItem"})
public class WorkItem
extends ManagedItem
implements IWorkItem {
    private Date actualEndDate;
    private Date actualStartDate;
    private Link isPartOf;
    private Date plannedEndDate;
    private Date plannedStartDate;
    private Link representedBy;
    private Set<Link> requiredBy = new HashSet<Link>();

    public WorkItem() {
    }

    public WorkItem(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"workItem", WorkItem.class);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean asLocalResource) {
        Object result = "";
        result = asLocalResource ? (String)result + "{a Local WorkItem Resource} - update WorkItem.toString() to present resource as desired." : String.valueOf(this.getAbout());
        return result;
    }

    @Override
    public void addRequiredBy(Link requiredBy) {
        this.requiredBy.add(requiredBy);
    }

    @Override
    @OslcName(value="actualEndDate")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#actualEndDate")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getActualEndDate() {
        return this.actualEndDate;
    }

    @Override
    @OslcName(value="actualStartDate")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#actualStartDate")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getActualStartDate() {
        return this.actualStartDate;
    }

    @Override
    @OslcName(value="isPartOf")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#isPartOf")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/promcode#WorkItem"})
    @OslcReadOnly(value=false)
    public Link getIsPartOf() {
        return this.isPartOf;
    }

    @Override
    @OslcName(value="plannedEndDate")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#plannedEndDate")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getPlannedEndDate() {
        return this.plannedEndDate;
    }

    @Override
    @OslcName(value="plannedStartDate")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#plannedStartDate")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getPlannedStartDate() {
        return this.plannedStartDate;
    }

    @Override
    @OslcName(value="representedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#representedBy")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    public Link getRepresentedBy() {
        return this.representedBy;
    }

    @Override
    @OslcName(value="requiredBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#requiredBy")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/promcode#ScopeItem", "http://open-services.net/ns/promcode#Artifact"})
    @OslcReadOnly(value=false)
    public Set<Link> getRequiredBy() {
        return this.requiredBy;
    }

    @Override
    public void setActualEndDate(Date actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    @Override
    public void setActualStartDate(Date actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    @Override
    public void setIsPartOf(Link isPartOf) {
        this.isPartOf = isPartOf;
    }

    @Override
    public void setPlannedEndDate(Date plannedEndDate) {
        this.plannedEndDate = plannedEndDate;
    }

    @Override
    public void setPlannedStartDate(Date plannedStartDate) {
        this.plannedStartDate = plannedStartDate;
    }

    @Override
    public void setRepresentedBy(Link representedBy) {
        this.representedBy = representedBy;
    }

    @Override
    public void setRequiredBy(Set<Link> requiredBy) {
        this.requiredBy.clear();
        if (requiredBy != null) {
            this.requiredBy.addAll(requiredBy);
        }
    }
}

