/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.promcode;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.promcode.IPlan;
import org.eclipse.lyo.oslc.domains.promcode.ManagedItemCollection;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/promcode#")
@OslcName(value="Plan")
@OslcResourceShape(title="Plan Shape", description="A Plan is a resource which is a subclass of ManagedItemCollection to describe a plan, which is agreed between an acquirer and a supplier at project initiation. A plan consists of ScopeItems, WorkItems, Artifacts, Targets and Measures.", describes={"http://open-services.net/ns/promcode#Plan"})
public class Plan
extends ManagedItemCollection
implements IPlan {
    private Link oslc_promcodeBelongsTo;
    private Set<Link> oslc_promcodeCollects = new HashSet<Link>();

    public Plan() {
    }

    public Plan(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"plan", Plan.class);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean asLocalResource) {
        Object result = "";
        result = asLocalResource ? (String)result + "{a Local Plan Resource} - update Plan.toString() to present resource as desired." : String.valueOf(this.getAbout());
        return result;
    }

    @Override
    public void addOslc_promcodeCollects(Link collects) {
        this.oslc_promcodeCollects.add(collects);
    }

    @Override
    @OslcName(value="belongsTo")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#belongsTo")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/promcode#Project"})
    @OslcReadOnly(value=false)
    public Link getOslc_promcodeBelongsTo() {
        return this.oslc_promcodeBelongsTo;
    }

    @Override
    @OslcName(value="collects")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#collects")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/promcode#Artifact", "http://open-services.net/ns/promcode#WorkItem", "http://open-services.net/ns/promcode#ScopeItem"})
    @OslcReadOnly(value=false)
    public Set<Link> getOslc_promcodeCollects() {
        return this.oslc_promcodeCollects;
    }

    @Override
    public void setOslc_promcodeBelongsTo(Link belongsTo) {
        this.oslc_promcodeBelongsTo = belongsTo;
    }

    @Override
    public void setOslc_promcodeCollects(Set<Link> collects) {
        this.oslc_promcodeCollects.clear();
        if (collects != null) {
            this.oslc_promcodeCollects.addAll(collects);
        }
    }
}

