/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.promcode;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.promcode.IMeasurement;
import org.eclipse.lyo.oslc.domains.promcode.Measure;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/promcode#")
@OslcName(value="Measurement")
@OslcResourceShape(title="Measurement Shape", description="A measurement measures some aspect of an artifact at some point in time.", describes={"http://open-services.net/ns/promcode#Measurement"})
public class Measurement
extends AbstractResource
implements IMeasurement {
    private Date date;
    private String description;
    private String identifier;
    private Link measures;
    private Set<Measure> observes = new HashSet<Measure>();

    public Measurement() {
    }

    public Measurement(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"measurement", Measurement.class);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean asLocalResource) {
        Object result = "";
        result = asLocalResource ? (String)result + "{a Local Measurement Resource} - update Measurement.toString() to present resource as desired." : String.valueOf(this.getAbout());
        return result;
    }

    @Override
    public void addObserves(Measure observes) {
        this.observes.add(observes);
    }

    @Override
    @OslcName(value="date")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/date")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getDate() {
        return this.date;
    }

    @Override
    @OslcName(value="description")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getDescription() {
        return this.description;
    }

    @Override
    @OslcName(value="identifier")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @OslcName(value="measures")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#measures")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/promcode#Artifact"})
    @OslcReadOnly(value=false)
    public Link getMeasures() {
        return this.measures;
    }

    @Override
    @OslcName(value="observes")
    @OslcPropertyDefinition(value="http://open-services.net/ns/promcode#observes")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Inline)
    @OslcRange(value={"http://open-services.net/ns/promcode#Measure"})
    @OslcReadOnly(value=false)
    public Set<Measure> getObserves() {
        return this.observes;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setMeasures(Link measures) {
        this.measures = measures;
    }

    @Override
    public void setObserves(Set<Measure> observes) {
        this.observes.clear();
        if (observes != null) {
            this.observes.addAll(observes);
        }
    }
}

