/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.config.Configuration;
import org.eclipse.lyo.oslc.domains.config.IBaseline;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/config#")
@OslcName(value="Baseline")
@OslcResourceShape(title="The shape of a baseline. Properties of a baseline defined in this specification must be read-only unless stated otherwise", description="", describes={"http://open-services.net/ns/config#Baseline"})
public class Baseline
extends Configuration
implements IBaseline {
    private Link baselineOfStream;
    private Date committed;
    private Set<Link> committer = new HashSet<Link>();
    private Link previousBaseline;
    private Set<Link> wasDerivedFrom = new HashSet<Link>();

    public Baseline() {
    }

    public Baseline(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"baseline", Baseline.class);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean asLocalResource) {
        Object result = "";
        result = asLocalResource ? (String)result + "{a Local Baseline Resource} - update Baseline.toString() to present resource as desired." : String.valueOf(this.getAbout());
        return result;
    }

    @Override
    public void addCommitter(Link committer) {
        this.committer.add(committer);
    }

    @Override
    public void addWasDerivedFrom(Link wasDerivedFrom) {
        this.wasDerivedFrom.add(wasDerivedFrom);
    }

    @Override
    @OslcName(value="baselineOfStream")
    @OslcPropertyDefinition(value="http://open-services.net/ns/config#baselineOfStream")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/config#Configuration"})
    @OslcReadOnly(value=false)
    public Link getBaselineOfStream() {
        return this.baselineOfStream;
    }

    @Override
    @OslcName(value="committed")
    @OslcPropertyDefinition(value="http://open-services.net/ns/config#committed")
    @OslcDescription(value="Date and time this version resource was checked in. Absent for mutable (checked out) versions.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCommitted() {
        return this.committed;
    }

    @Override
    @OslcName(value="committer")
    @OslcPropertyDefinition(value="http://open-services.net/ns/config#committer")
    @OslcDescription(value="The entity that checked in this version.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person", "http://xmlns.com/foaf/0.1/Agent"})
    @OslcReadOnly(value=true)
    public Set<Link> getCommitter() {
        return this.committer;
    }

    @Override
    @OslcName(value="previousBaseline")
    @OslcPropertyDefinition(value="http://open-services.net/ns/config#previousBaseline")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/config#Baseline"})
    @OslcReadOnly(value=false)
    public Link getPreviousBaseline() {
        return this.previousBaseline;
    }

    @Override
    @OslcName(value="wasDerivedFrom")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/prov#wasDerivedFrom")
    @OslcDescription(value="")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/config#Configuration"})
    @OslcReadOnly(value=false)
    public Set<Link> getWasDerivedFrom() {
        return this.wasDerivedFrom;
    }

    @Override
    public void setBaselineOfStream(Link baselineOfStream) {
        this.baselineOfStream = baselineOfStream;
    }

    @Override
    public void setCommitted(Date committed) {
        this.committed = committed;
    }

    @Override
    public void setCommitter(Set<Link> committer) {
        this.committer.clear();
        if (committer != null) {
            this.committer.addAll(committer);
        }
    }

    @Override
    public void setPreviousBaseline(Link previousBaseline) {
        this.previousBaseline = previousBaseline;
    }

    @Override
    public void setWasDerivedFrom(Set<Link> wasDerivedFrom) {
        this.wasDerivedFrom.clear();
        if (wasDerivedFrom != null) {
            this.wasDerivedFrom.addAll(wasDerivedFrom);
        }
    }
}

