/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.cm;

import java.util.Date;
import java.util.Set;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/cm#")
@OslcName(value="ChangeRequest")
@OslcResourceShape(title="ChangeRequest Shape", describes={"http://open-services.net/ns/cm#ChangeRequest"})
public interface IChangeRequest {
    public void addSubject(String var1);

    public void addCreator(Link var1);

    public void addContributor(Link var1);

    public void addServiceProvider(Link var1);

    public void addInstanceShape(Link var1);

    public void addRelatedChangeRequest(Link var1);

    public void addAffectsPlanItem(Link var1);

    public void addAffectedByDefect(Link var1);

    public void addTracksRequirement(Link var1);

    public void addImplementsRequirement(Link var1);

    public void addAffectsRequirement(Link var1);

    public void addTracksChangeSet(Link var1);

    public void addParent(Link var1);

    public void addPriority(Link var1);

    public void addAuthorizer(Link var1);

    @OslcName(value="shortTitle")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#shortTitle")
    @OslcDescription(value="Shorter form of dcterms:title for the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getShortTitle();

    @OslcName(value="description")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcDescription(value="Descriptive text about resource represented as rich text in XHTML content. SHOULD include only content that is valid and suitable inside an XHTML <div> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getDescription();

    @OslcName(value="title")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcDescription(value="Title of the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getTitle();

    @OslcName(value="identifier")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcDescription(value="A unique identifier for a resource. Typically read-only and assigned by the service provider when a resource is created. Not typically intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getIdentifier();

    @OslcName(value="subject")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/subject")
    @OslcDescription(value="Tag or keyword for a resource. Each occurrence of a dcterms:subject property denotes an additional tag for the resource.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    @OslcTitle(value="")
    public Set<String> getSubject();

    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcDescription(value="Creator or creators of the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getCreator();

    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcDescription(value="Contributor or contributors to the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getContributor();

    @OslcName(value="created")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcDescription(value="Timestamp of resource creation")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCreated();

    @OslcName(value="modified")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcDescription(value="Timestamp of latest resource modification")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getModified();

    @OslcName(value="serviceProvider")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcDescription(value="A link to the resource's OSLC Service Provider. There may be cases when the subject resource is available from a service provider that implements multiple domain specifications, which could result in multiple values for this property.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getServiceProvider();

    @OslcName(value="instanceShape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcDescription(value="The URI of a Resource Shape that describes the possible properties, occurrence, value types, allowed values and labels. This shape information is useful in displaying the subject resource as well as guiding clients in performing modifications. Instance shapes may be specific to the authenticated user associated with the request that retrieved the resource, the current state of the resource and other factors and thus should not be cached.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getInstanceShape();

    @OslcName(value="discussedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#discussedBy")
    @OslcDescription(value="A series of notes and comments about this resource.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/core#Discussion"})
    @OslcReadOnly(value=false)
    public Link getDiscussedBy();

    @OslcName(value="closeDate")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#closeDate")
    @OslcDescription(value="The date at which no further activity or work is intended to be conducted.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCloseDate();

    @OslcName(value="status")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#status")
    @OslcDescription(value="Used to indicate the status of the change request based on values defined by the service provider. Most often a read-only property. Some possible values may include: 'Submitted', 'Done', 'InProgress', etc.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getStatus();

    @OslcName(value="closed")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#closed")
    @OslcDescription(value="Whether or not the Change Request is completely done, no further fixes or fix verification is needed.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Boolean)
    @OslcReadOnly(value=false)
    public Boolean isClosed();

    @OslcName(value="inProgress")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#inProgress")
    @OslcDescription(value="Whether or not the Change Request in a state indicating that active work is occurring. If oslc_cm:inprogress is true, then oslc_cm:fixed and oslc_cm:closed must also be false")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Boolean)
    @OslcReadOnly(value=false)
    public Boolean isInProgress();

    @OslcName(value="fixed")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#fixed")
    @OslcDescription(value="Whether or not the Change Request has been fixed.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Boolean)
    @OslcReadOnly(value=false)
    public Boolean isFixed();

    @OslcName(value="approved")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#approved")
    @OslcDescription(value="Whether or not the Change Request has been approved.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Boolean)
    @OslcReadOnly(value=false)
    public Boolean isApproved();

    @OslcName(value="reviewed")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#reviewed")
    @OslcDescription(value="Whether or not the Change Request has been reviewed.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Boolean)
    @OslcReadOnly(value=false)
    public Boolean isReviewed();

    @OslcName(value="verified")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#verified")
    @OslcDescription(value="Whether or not the resolution or fix of the Change Request has been verified.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Boolean)
    @OslcReadOnly(value=false)
    public Boolean isVerified();

    @OslcName(value="relatedChangeRequest")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#relatedChangeRequest")
    @OslcDescription(value="This relationship is loosely coupled and has no specific meaning. It is likely that the target resource will be an oslc_cm:ChangeRequest but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getRelatedChangeRequest();

    @OslcName(value="affectsPlanItem")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#affectsPlanItem")
    @OslcDescription(value="Change request affects a plan item. It is likely that the target resource will be an oslc_cm:ChangeRequest but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getAffectsPlanItem();

    @OslcName(value="affectedByDefect")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#affectedByDefect")
    @OslcDescription(value="Change request is affected by a reported defect. It is likely that the target resource will be an oslc_cm:ChangeRequest but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/cm#Defect"})
    @OslcReadOnly(value=false)
    public Set<Link> getAffectedByDefect();

    @OslcName(value="tracksRequirement")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#tracksRequirement")
    @OslcDescription(value="Tracks the associated Requirement or Requirement ChangeSet resources. It is likely that the target resource will be an oslc_rm:Requirement but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    public Set<Link> getTracksRequirement();

    @OslcName(value="implementsRequirement")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#implementsRequirement")
    @OslcDescription(value="Implements associated Requirement. It is likely that the target resource will be an oslc_rm:Requirement but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    public Set<Link> getImplementsRequirement();

    @OslcName(value="affectsRequirement")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#affectsRequirement")
    @OslcDescription(value="Change request affecting a Requirement. It is likely that the target resource will be an oslc_rm:Requirement but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    public Set<Link> getAffectsRequirement();

    @OslcName(value="tracksChangeSet")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#tracksChangeSet")
    @OslcDescription(value="Tracks SCM change set resource. It is likely that the target resource will be an oslc_scm:ChangeSet but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/config#ChangeSet"})
    @OslcReadOnly(value=false)
    public Set<Link> getTracksChangeSet();

    @OslcName(value="parent")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#parent")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/cm#ChangeRequest"})
    @OslcReadOnly(value=false)
    public Set<Link> getParent();

    @OslcName(value="priority")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#priority")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/cm#Priority"})
    @OslcReadOnly(value=false)
    public Set<Link> getPriority();

    @OslcName(value="state")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#state")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/cm#State"})
    @OslcReadOnly(value=false)
    public Link getState();

    @OslcName(value="authorizer")
    @OslcPropertyDefinition(value="http://open-services.net/ns/cm#authorizer")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Agent"})
    @OslcReadOnly(value=false)
    public Set<Link> getAuthorizer();

    public void setShortTitle(String var1);

    public void setDescription(String var1);

    public void setTitle(String var1);

    public void setIdentifier(String var1);

    public void setSubject(Set<String> var1);

    public void setCreator(Set<Link> var1);

    public void setContributor(Set<Link> var1);

    public void setCreated(Date var1);

    public void setModified(Date var1);

    public void setServiceProvider(Set<Link> var1);

    public void setInstanceShape(Set<Link> var1);

    public void setDiscussedBy(Link var1);

    public void setCloseDate(Date var1);

    public void setStatus(String var1);

    public void setClosed(Boolean var1);

    public void setInProgress(Boolean var1);

    public void setFixed(Boolean var1);

    public void setApproved(Boolean var1);

    public void setReviewed(Boolean var1);

    public void setVerified(Boolean var1);

    public void setRelatedChangeRequest(Set<Link> var1);

    public void setAffectsPlanItem(Set<Link> var1);

    public void setAffectedByDefect(Set<Link> var1);

    public void setTracksRequirement(Set<Link> var1);

    public void setImplementsRequirement(Set<Link> var1);

    public void setAffectsRequirement(Set<Link> var1);

    public void setTracksChangeSet(Set<Link> var1);

    public void setParent(Set<Link> var1);

    public void setPriority(Set<Link> var1);

    public void setState(Link var1);

    public void setAuthorizer(Set<Link> var1);
}

