/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.qm;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.qm.ITestResult;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/qm#")
@OslcName(value="TestResult")
@OslcResourceShape(title="TestResult Resource Shape", describes={"http://open-services.net/ns/qm#TestResult"})
public class TestResult
extends AbstractResource
implements ITestResult {
    private Date created;
    private String identifier;
    private Date modified;
    private Set<Link> instanceShape = new HashSet<Link>();
    private String title;
    private Set<Link> type = new HashSet<Link>();
    private Set<Link> serviceProvider = new HashSet<Link>();
    private String status;
    private Set<Link> affectedByChangeRequest = new HashSet<Link>();
    private Link executesTestScript;
    private Link producedByTestExecutionRecord;
    private Link reportsOnTestCase;
    private Link reportsOnTestPlan;

    public TestResult() {
    }

    public TestResult(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"testResult", TestResult.class);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean asLocalResource) {
        String result = "";
        result = asLocalResource ? result + "{a Local TestResult Resource} - update TestResult.toString() to present resource as desired." : String.valueOf(this.getAbout());
        return result;
    }

    @Override
    public void addInstanceShape(Link instanceShape) {
        this.instanceShape.add(instanceShape);
    }

    @Override
    public void addType(Link type) {
        this.type.add(type);
    }

    @Override
    public void addServiceProvider(Link serviceProvider) {
        this.serviceProvider.add(serviceProvider);
    }

    @Override
    public void addAffectedByChangeRequest(Link affectedByChangeRequest) {
        this.affectedByChangeRequest.add(affectedByChangeRequest);
    }

    @Override
    @OslcName(value="created")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcDescription(value="Timestamp of resource creation")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCreated() {
        return this.created;
    }

    @Override
    @OslcName(value="identifier")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcDescription(value="A unique identifier for a resource. Typically read-only and assigned by the service provider when a resource is created. Not typically intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @OslcName(value="modified")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcDescription(value="Timestamp of latest resource modification")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getModified() {
        return this.modified;
    }

    @Override
    @OslcName(value="instanceShape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcDescription(value="The URI of a Resource Shape that describes the possible properties, occurrence, value types, allowed values and labels. This shape information is useful in displaying the subject resource as well as guiding clients in performing modifications. Instance shapes may be specific to the authenticated user associated with the request that retrieved the resource, the current state of the resource and other factors and thus should not be cached.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getInstanceShape() {
        return this.instanceShape;
    }

    @Override
    @OslcName(value="title")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcDescription(value="Title of the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getTitle() {
        return this.title;
    }

    @Override
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcDescription(value="The resource type URIs")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    public Set<Link> getType() {
        return this.type;
    }

    @Override
    @OslcName(value="serviceProvider")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcDescription(value="A link to the resource's OSLC Service Provider. There may be cases when the subject resource is available from a service provider that implements multiple domain specifications, which could result in multiple values for this property.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    @OslcName(value="status")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#status")
    @OslcDescription(value="Used to indicate the state of the Test Result based on values defined by the service provider. Most often a read-only property.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getStatus() {
        return this.status;
    }

    @Override
    @OslcName(value="affectedByChangeRequest")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#affectedByChangeRequest")
    @OslcDescription(value="Change request that affects the Test Result. It is likely that the target resource will be an oslc_cm:ChangeRequest but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/cm#ChangeRequest"})
    @OslcReadOnly(value=false)
    public Set<Link> getAffectedByChangeRequest() {
        return this.affectedByChangeRequest;
    }

    @Override
    @OslcName(value="executesTestScript")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#executesTestScript")
    @OslcDescription(value="Test Script executed to produce the Test Result. It is likely that the target resource will be an oslc_qm:TestScript but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/qm#TestScript"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="")
    public Link getExecutesTestScript() {
        return this.executesTestScript;
    }

    @Override
    @OslcName(value="producedByTestExecutionRecord")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#producedByTestExecutionRecord")
    @OslcDescription(value="Test Execution Record that the Test Result was produced by. It is likely that the target resource will be an oslc_qm:TestExecutionRecord but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/qm#TestExecutionRecord"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="")
    public Link getProducedByTestExecutionRecord() {
        return this.producedByTestExecutionRecord;
    }

    @Override
    @OslcName(value="reportsOnTestCase")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#reportsOnTestCase")
    @OslcDescription(value="Test Case that the Test Result reports on. It is likely that the target resource will be an oslc_qm:TestCase but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/qm#TestCase"})
    @OslcReadOnly(value=false)
    public Link getReportsOnTestCase() {
        return this.reportsOnTestCase;
    }

    @Override
    @OslcName(value="reportsOnTestPlan")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#reportsOnTestPlan")
    @OslcDescription(value="Test Plan that the Test Execution Record reports on. It is likely that the target resource will be an oslc_qm:TestPlan but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://open-services.net/ns/qm#TestPlan"})
    @OslcReadOnly(value=false)
    public Link getReportsOnTestPlan() {
        return this.reportsOnTestPlan;
    }

    @Override
    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Override
    public void setInstanceShape(Set<Link> instanceShape) {
        this.instanceShape.clear();
        if (instanceShape != null) {
            this.instanceShape.addAll(instanceShape);
        }
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setType(Set<Link> type) {
        this.type.clear();
        if (type != null) {
            this.type.addAll(type);
        }
    }

    @Override
    public void setServiceProvider(Set<Link> serviceProvider) {
        this.serviceProvider.clear();
        if (serviceProvider != null) {
            this.serviceProvider.addAll(serviceProvider);
        }
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public void setAffectedByChangeRequest(Set<Link> affectedByChangeRequest) {
        this.affectedByChangeRequest.clear();
        if (affectedByChangeRequest != null) {
            this.affectedByChangeRequest.addAll(affectedByChangeRequest);
        }
    }

    @Override
    public void setExecutesTestScript(Link executesTestScript) {
        this.executesTestScript = executesTestScript;
    }

    @Override
    public void setProducedByTestExecutionRecord(Link producedByTestExecutionRecord) {
        this.producedByTestExecutionRecord = producedByTestExecutionRecord;
    }

    @Override
    public void setReportsOnTestCase(Link reportsOnTestCase) {
        this.reportsOnTestCase = reportsOnTestCase;
    }

    @Override
    public void setReportsOnTestPlan(Link reportsOnTestPlan) {
        this.reportsOnTestPlan = reportsOnTestPlan;
    }
}

