/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.qm;

import java.util.Date;
import java.util.Set;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/qm#")
@OslcName(value="TestScript")
@OslcResourceShape(title="TestScript Resource Shape", describes={"http://open-services.net/ns/qm#TestScript"})
public interface ITestScript {
    public void addContributor(Link var1);

    public void addCreator(Link var1);

    public void addInstanceShape(Link var1);

    public void addServiceProvider(Link var1);

    public void addType(Link var1);

    public void addExecutionInstructions(Link var1);

    public void addRelatedChangeRequest(Link var1);

    public void addValidatesRequirement(Link var1);

    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcDescription(value="Contributor or contributors to the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getContributor();

    @OslcName(value="created")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcDescription(value="Timestamp of resource creation")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCreated();

    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcDescription(value="Creator or creators of the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getCreator();

    @OslcName(value="description")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcDescription(value="Descriptive text about resource represented as rich text in XHTML content. SHOULD include only content that is valid and suitable inside an XHTML <div> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getDescription();

    @OslcName(value="identifier")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcDescription(value="A unique identifier for a resource. Typically read-only and assigned by the service provider when a resource is created. Not typically intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getIdentifier();

    @OslcName(value="modified")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcDescription(value="Timestamp of latest resource modification")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getModified();

    @OslcName(value="instanceShape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcDescription(value="The URI of a Resource Shape that describes the possible properties, occurrence, value types, allowed values and labels. This shape information is useful in displaying the subject resource as well as guiding clients in performing modifications. Instance shapes may be specific to the authenticated user associated with the request that retrieved the resource, the current state of the resource and other factors and thus should not be cached.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getInstanceShape();

    @OslcName(value="serviceProvider")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcDescription(value="A link to the resource's OSLC Service Provider. There may be cases when the subject resource is available from a service provider that implements multiple domain specifications, which could result in multiple values for this property.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getServiceProvider();

    @OslcName(value="title")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcDescription(value="Title of the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getTitle();

    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcDescription(value="The resource type URIs")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    public Set<Link> getType();

    @OslcName(value="executionInstructions")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#executionInstructions")
    @OslcDescription(value="Instructions for executing the test script. Note that the value of Occurs is undefined. The resource shape document provided by the QM service provider may be consulted for its value.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getExecutionInstructions();

    @OslcName(value="relatedChangeRequest")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#relatedChangeRequest")
    @OslcDescription(value="A related change request. It is likely that the target resource will be an oslc_cm:ChangeRequest but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/cm#ChangeRequest"})
    @OslcReadOnly(value=false)
    public Set<Link> getRelatedChangeRequest();

    @OslcName(value="validatesRequirement")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#validatesRequirement")
    @OslcDescription(value="Requirement that is validated by the Test Case. It is likely that the target resource will be an oslc_rm:Requirement but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    public Set<Link> getValidatesRequirement();

    public void setContributor(Set<Link> var1);

    public void setCreated(Date var1);

    public void setCreator(Set<Link> var1);

    public void setDescription(String var1);

    public void setIdentifier(String var1);

    public void setModified(Date var1);

    public void setInstanceShape(Set<Link> var1);

    public void setServiceProvider(Set<Link> var1);

    public void setTitle(String var1);

    public void setType(Set<Link> var1);

    public void setExecutionInstructions(Set<Link> var1);

    public void setRelatedChangeRequest(Set<Link> var1);

    public void setValidatesRequirement(Set<Link> var1);
}

