/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc.domains.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lyo.oslc.domains.config.IVersionResource;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ResourceShapeFactory;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/config#")
@OslcName(value="VersionResource")
@OslcResourceShape(title="VersionResource Resource Shape", describes={"http://open-services.net/ns/config#VersionResource"})
public class VersionResource
extends AbstractResource
implements IVersionResource {
    private Set<Link> contributor = new HashSet<Link>();
    private Date created;
    private Set<Link> creator = new HashSet<Link>();
    private String description;
    private String identifier;
    private Link isVersionOf;
    private Date modified;
    private Set<String> subject = new HashSet<String>();
    private String title;
    private Date committed;
    private Set<Link> committer = new HashSet<Link>();
    private Set<String> component = new HashSet<String>();
    private String versionId;
    private Set<Link> instanceShape = new HashSet<Link>();
    private Link modifiedBy;
    private Set<Link> serviceProvider = new HashSet<Link>();
    private String shortId;
    private String shortTitle;
    private Set<Link> type = new HashSet<Link>();
    private Set<Link> wasDerivedFrom = new HashSet<Link>();
    private Set<Link> wasRevisionOf = new HashSet<Link>();

    public VersionResource() {
    }

    public VersionResource(URI about) {
        super(about);
    }

    public static ResourceShape createResourceShape() throws OslcCoreApplicationException, URISyntaxException {
        return ResourceShapeFactory.createResourceShape((String)OSLC4JUtils.getServletURI(), (String)"resourceShapes", (String)"versionResource", VersionResource.class);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean asLocalResource) {
        String result = "";
        result = asLocalResource ? result + "{a Local VersionResource Resource} - update VersionResource.toString() to present resource as desired." : String.valueOf(this.getAbout());
        return result;
    }

    @Override
    public void addContributor(Link contributor) {
        this.contributor.add(contributor);
    }

    @Override
    public void addCreator(Link creator) {
        this.creator.add(creator);
    }

    @Override
    public void addSubject(String subject) {
        this.subject.add(subject);
    }

    @Override
    public void addCommitter(Link committer) {
        this.committer.add(committer);
    }

    @Override
    public void addComponent(String component) {
        this.component.add(component);
    }

    @Override
    public void addInstanceShape(Link instanceShape) {
        this.instanceShape.add(instanceShape);
    }

    @Override
    public void addServiceProvider(Link serviceProvider) {
        this.serviceProvider.add(serviceProvider);
    }

    @Override
    public void addType(Link type) {
        this.type.add(type);
    }

    @Override
    public void addWasDerivedFrom(Link wasDerivedFrom) {
        this.wasDerivedFrom.add(wasDerivedFrom);
    }

    @Override
    public void addWasRevisionOf(Link wasRevisionOf) {
        this.wasRevisionOf.add(wasRevisionOf);
    }

    @Override
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcDescription(value="Contributor or contributors to the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getContributor() {
        return this.contributor;
    }

    @Override
    @OslcName(value="created")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcDescription(value="Timestamp of resource creation")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCreated() {
        return this.created;
    }

    @Override
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcDescription(value="Creator or creators of the resource. It is likely that the target resource will be a foaf:Person but that is not necessarily the case.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcReadOnly(value=false)
    public Set<Link> getCreator() {
        return this.creator;
    }

    @Override
    @OslcName(value="description")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcDescription(value="Descriptive text about resource represented as rich text in XHTML content. SHOULD include only content that is valid and suitable inside an XHTML <div> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getDescription() {
        return this.description;
    }

    @Override
    @OslcName(value="identifier")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcDescription(value="A unique identifier for a resource. Typically read-only and assigned by the service provider when a resource is created. Not typically intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @OslcName(value="isVersionOf")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/isVersionOf")
    @OslcDescription(value="The concept resource of which this resource is a version. The subject of this property must be the version resource URI.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Link getIsVersionOf() {
        return this.isVersionOf;
    }

    @Override
    @OslcName(value="modified")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcDescription(value="Timestamp of latest resource modification")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getModified() {
        return this.modified;
    }

    @Override
    @OslcName(value="subject")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/subject")
    @OslcDescription(value="Tag or keyword for a resource. Each occurrence of a dcterms:subject property denotes an additional tag for the resource.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    @OslcTitle(value="")
    public Set<String> getSubject() {
        return this.subject;
    }

    @Override
    @OslcName(value="title")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcDescription(value="Title of the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getTitle() {
        return this.title;
    }

    @Override
    @OslcName(value="committed")
    @OslcPropertyDefinition(value="http://open-services.net/ns/config#committed")
    @OslcDescription(value="Date and time this version resource was checked in. Absent for mutable (checked out) versions.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.DateTime)
    @OslcReadOnly(value=false)
    public Date getCommitted() {
        return this.committed;
    }

    @Override
    @OslcName(value="committer")
    @OslcPropertyDefinition(value="http://open-services.net/ns/config#committer")
    @OslcDescription(value="The entity that checked in this version.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=true)
    public Set<Link> getCommitter() {
        return this.committer;
    }

    @Override
    @OslcName(value="component")
    @OslcPropertyDefinition(value="http://open-services.net/ns/config#component")
    @OslcDescription(value="The component to which this version belongs. Configuration Management provider should indicate the owning component for each version resource using either this property, or using the membership relationship from the component LDPC.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public Set<String> getComponent() {
        return this.component;
    }

    @Override
    @OslcName(value="versionId")
    @OslcPropertyDefinition(value="http://open-services.net/ns/config#versionId")
    @OslcDescription(value="A short human-readable identifier for the version of a resource. All versioned resources should have this property; where the property is present, this identifier must be unique amongst all currently existing versions of the same concept resource. The subject of this property should be the concept resource URI.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getVersionId() {
        return this.versionId;
    }

    @Override
    @OslcName(value="instanceShape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcDescription(value="The URI of a Resource Shape that describes the possible properties, occurrence, value types, allowed values and labels. This shape information is useful in displaying the subject resource as well as guiding clients in performing modifications. Instance shapes may be specific to the authenticated user associated with the request that retrieved the resource, the current state of the resource and other factors and thus should not be cached.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getInstanceShape() {
        return this.instanceShape;
    }

    @Override
    @OslcName(value="modifiedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#modifiedBy")
    @OslcDescription(value="The URI of a resource describing the entity that most recently modified the subject resource. The link target is usually a foaf:Person or foaf:Agent, but could be any type. This is modeled after dcterms:creator, but Dublin Core currently has no equivalent property.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    public Link getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    @OslcName(value="serviceProvider")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcDescription(value="A link to the resource's OSLC Service Provider. There may be cases when the subject resource is available from a service provider that implements multiple domain specifications, which could result in multiple values for this property.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    @OslcName(value="shortId")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#shortId")
    @OslcDescription(value="Shorter form of dcterms:identifier for the resource, such as a number.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcValueType(value=ValueType.String)
    @OslcReadOnly(value=false)
    public String getShortId() {
        return this.shortId;
    }

    @Override
    @OslcName(value="shortTitle")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#shortTitle")
    @OslcDescription(value="Shorter form of dcterms:title for the resource represented as rich text in XHTML content. SHOULD include only content that is valid inside an XHTML <span> element.")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcValueType(value=ValueType.XMLLiteral)
    @OslcReadOnly(value=false)
    public String getShortTitle() {
        return this.shortTitle;
    }

    @Override
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcDescription(value="The resource type URIs")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcReadOnly(value=false)
    public Set<Link> getType() {
        return this.type;
    }

    @Override
    @OslcName(value="wasDerivedFrom")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/prov#wasDerivedFrom")
    @OslcDescription(value="A resource from which this version was derived. This is likely to reference a different concept resource; use of prov:wasRevisionOf is recommended to indicate an earlier version of the same concept resource. The subject of each instance of this property must be the concept resource URI; the object can be a version resource URI, or a concept resource URI (possibly for a non-versioned resource).")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getWasDerivedFrom() {
        return this.wasDerivedFrom;
    }

    @Override
    @OslcName(value="wasRevisionOf")
    @OslcPropertyDefinition(value="http://www.w3.org/ns/prov#wasRevisionOf")
    @OslcDescription(value="A resource from which this version was derived. This is likely to reference an earlier version of the same concept resource; use of prov:wasDerivedFrom is recommended to indicate an earlier version of a different concept resource. The subject of each instance of this property must be the concept resource URI; the object is likely to be a version resource URI.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcValueType(value=ValueType.Resource)
    @OslcRepresentation(value=Representation.Reference)
    @OslcReadOnly(value=false)
    public Set<Link> getWasRevisionOf() {
        return this.wasRevisionOf;
    }

    @Override
    public void setContributor(Set<Link> contributor) {
        this.contributor.clear();
        if (contributor != null) {
            this.contributor.addAll(contributor);
        }
    }

    @Override
    public void setCreated(Date created) {
        this.created = created;
    }

    @Override
    public void setCreator(Set<Link> creator) {
        this.creator.clear();
        if (creator != null) {
            this.creator.addAll(creator);
        }
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setIsVersionOf(Link isVersionOf) {
        this.isVersionOf = isVersionOf;
    }

    @Override
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Override
    public void setSubject(Set<String> subject) {
        this.subject.clear();
        if (subject != null) {
            this.subject.addAll(subject);
        }
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setCommitted(Date committed) {
        this.committed = committed;
    }

    @Override
    public void setCommitter(Set<Link> committer) {
        this.committer.clear();
        if (committer != null) {
            this.committer.addAll(committer);
        }
    }

    @Override
    public void setComponent(Set<String> component) {
        this.component.clear();
        if (component != null) {
            this.component.addAll(component);
        }
    }

    @Override
    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    @Override
    public void setInstanceShape(Set<Link> instanceShape) {
        this.instanceShape.clear();
        if (instanceShape != null) {
            this.instanceShape.addAll(instanceShape);
        }
    }

    @Override
    public void setModifiedBy(Link modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Override
    public void setServiceProvider(Set<Link> serviceProvider) {
        this.serviceProvider.clear();
        if (serviceProvider != null) {
            this.serviceProvider.addAll(serviceProvider);
        }
    }

    @Override
    public void setShortId(String shortId) {
        this.shortId = shortId;
    }

    @Override
    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    @Override
    public void setType(Set<Link> type) {
        this.type.clear();
        if (type != null) {
            this.type.addAll(type);
        }
    }

    @Override
    public void setWasDerivedFrom(Set<Link> wasDerivedFrom) {
        this.wasDerivedFrom.clear();
        if (wasDerivedFrom != null) {
            this.wasDerivedFrom.addAll(wasDerivedFrom);
        }
    }

    @Override
    public void setWasRevisionOf(Set<Link> wasRevisionOf) {
        this.wasRevisionOf.clear();
        if (wasRevisionOf != null) {
            this.wasRevisionOf.addAll(wasRevisionOf);
        }
    }
}

